/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.index.BTree;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Constraint;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.SQLException;

public class UniqueSingleColumnConstraint
extends Constraint {
    private static final L10N L = new L10N(UniqueSingleColumnConstraint._resin_compat_class_0());
    private final Column _uniqueColumn;
    private static Class _resin_compat_class_0;

    public UniqueSingleColumnConstraint(Column column) {
        this._uniqueColumn = column;
    }

    public void validate(TableIterator[] sourceRows, QueryContext queryContext, Transaction xa) throws SQLException {
        Column column = this._uniqueColumn;
        int columnOffset = column.getColumnOffset();
        BTree index = column.getIndex();
        if (index != null) {
            this.validateIndex(sourceRows, queryContext, xa);
            return;
        }
        TableIterator sourceRow = sourceRows[0];
        Object value = null;
        Table table = sourceRow.getTable();
        TableIterator iter = table.createTableIterator();
        try {
            byte[] sourceBuffer = sourceRow.getBuffer();
            int sourceOffset = sourceRow.getRowOffset();
            iter.init(queryContext);
            while (iter.next()) {
                byte[] iterBuffer = iter.getBuffer();
                iter.prevRow();
                while (iter.nextRow()) {
                    int iterOffset = iter.getRowOffset();
                    if (iterBuffer == sourceBuffer && iterOffset == sourceOffset || !column.isEqual(iterBuffer, iterOffset, sourceBuffer, sourceOffset)) continue;
                    throw new SQLException(L.l("`{0}' in {1}.{2} fails uniqueness constraint.", column.getString(iterBuffer, iterOffset), table.getName(), column.getName()));
                }
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
        finally {
            iter.free();
        }
    }

    private void validateIndex(TableIterator[] sourceRows, QueryContext context, Transaction xa) throws SQLException {
        try {
            Column column = this._uniqueColumn;
            TableIterator sourceRow = sourceRows[0];
            byte[] sourceBuffer = sourceRow.getBuffer();
            int sourceOffset = sourceRow.getRowOffset();
            byte[] buffer = context.getBuffer();
            BTree index = column.getIndex();
            int length = column.getLength();
            int offset = sourceOffset + this._uniqueColumn.getColumnOffset();
            long value = index.lookup(sourceBuffer, offset, length, context.getTransaction());
            if (value != 0L) {
                Table table = sourceRow.getTable();
                throw new SQLException(L.l("`{0}' in {1}.{2} fails uniqueness constraint.", column.getString(sourceBuffer, sourceOffset), table.getName(), column.getName()));
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.table.UniqueSingleColumnConstraint");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

