/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.index.BTree;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Row;
import com.caucho.db.table.TableIterator;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;

class NumericColumn
extends Column {
    private int _precision;
    private int _scale;
    private long _offset;

    NumericColumn(Row row, String name, int precision, int scale) {
        super(row, name);
        this._precision = precision;
        this._scale = scale;
        this._offset = 1L;
        for (int i = 0; i < scale; ++i) {
            this._offset *= 10L;
        }
    }

    public int getTypeCode() {
        return 7;
    }

    public int getPrecision() {
        return this._precision;
    }

    public int getScale() {
        return this._scale;
    }

    public Class getJavaType() {
        return Double.TYPE;
    }

    public int getDeclarationSize() {
        return 8;
    }

    public int getLength() {
        return 8;
    }

    void setString(Transaction xa, byte[] block, int rowOffset, String str) throws SQLException {
        if (str == null || str.length() == 0) {
            this.setNull(block, rowOffset);
        } else {
            this.setDouble(xa, block, rowOffset, Double.parseDouble(str));
        }
    }

    public String getString(byte[] block, int rowOffset) throws SQLException {
        if (this.isNull(block, rowOffset)) {
            return null;
        }
        long value = this.getNumeric(block, rowOffset);
        CharBuffer cb = new CharBuffer();
        long head = value / this._offset;
        long tail = value % this._offset;
        cb.append(head);
        cb.append('.');
        cb.append(tail);
        return cb.toString();
    }

    public void setDouble(Transaction xa, byte[] block, int rowOffset, double v) throws SQLException {
        this.setNumeric(xa, block, rowOffset, (long)(v * (double)this._offset + 0.5));
    }

    public double getDouble(Transaction xa, byte[] block, int rowOffset) throws SQLException {
        return (double)this.getNumeric(block, rowOffset) / (double)this._offset;
    }

    public void evalToResult(byte[] block, int rowOffset, SelectResult result) throws SQLException {
        if (this.isNull(block, rowOffset)) {
            result.writeNull();
            return;
        }
        result.writeString(this.getString(block, rowOffset));
    }

    int evalToBuffer(byte[] block, int rowOffset, byte[] buffer, int bufferOffset) throws SQLException {
        if (this.isNull(block, rowOffset)) {
            return 0;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = 8;
        System.arraycopy(block, startOffset, buffer, bufferOffset, len);
        return len;
    }

    void setExpr(Transaction xa, byte[] block, int rowOffset, Expr expr, QueryContext context) throws SQLException {
        if (expr.isNull(null)) {
            this.setNull(block, rowOffset);
        } else {
            this.setDouble(xa, block, rowOffset, expr.evalDouble(context));
        }
    }

    public boolean isEqual(byte[] block1, int rowOffset1, byte[] block2, int rowOffset2) {
        if (this.isNull(block1, rowOffset1) != this.isNull(block2, rowOffset2)) {
            return false;
        }
        int startOffset1 = rowOffset1 + this._columnOffset;
        int startOffset2 = rowOffset2 + this._columnOffset;
        return block1[startOffset1 + 0] == block2[startOffset2 + 0] && block1[startOffset1 + 1] == block2[startOffset2 + 1] && block1[startOffset1 + 2] == block2[startOffset2 + 2] && block1[startOffset1 + 3] == block2[startOffset2 + 3] && block1[startOffset1 + 4] == block2[startOffset2 + 4] && block1[startOffset1 + 5] == block2[startOffset2 + 5] && block1[startOffset1 + 6] == block2[startOffset2 + 6] && block1[startOffset1 + 7] == block2[startOffset2 + 7];
    }

    void setIndex(Transaction xa, byte[] block, int rowOffset, long rowAddr, QueryContext context) throws SQLException {
        BTree index = this.getIndex();
        if (index == null) {
            return;
        }
        index.insert(block, rowOffset + this._columnOffset, 8, rowAddr, xa);
    }

    public void set(TableIterator iter, Expr expr, QueryContext context) throws SQLException {
        iter.setDirty();
        this.setDouble(iter.getTransaction(), iter.getBuffer(), iter.getRowOffset(), expr.evalDouble(context));
    }

    void delete(Transaction xa, byte[] block, int rowOffset) throws SQLException {
        BTree index = this.getIndex();
        if (index != null) {
            index.remove(block, rowOffset + this._columnOffset, 8, xa);
        }
    }

    void setNumeric(Transaction xa, byte[] block, int rowOffset, long value) {
        int offset = rowOffset + this._columnOffset;
        block[offset++] = (byte)(value >> 56);
        block[offset++] = (byte)(value >> 48);
        block[offset++] = (byte)(value >> 40);
        block[offset++] = (byte)(value >> 32);
        block[offset++] = (byte)(value >> 24);
        block[offset++] = (byte)(value >> 16);
        block[offset++] = (byte)(value >> 8);
        block[offset++] = (byte)value;
        this.setNonNull(block, rowOffset);
    }

    long getNumeric(byte[] block, int rowOffset) {
        if (this.isNull(block, rowOffset)) {
            return 0L;
        }
        int offset = rowOffset + this._columnOffset;
        long value = 0L;
        value = ((long)block[offset++] & 0xFFL) << 56;
        value |= ((long)block[offset++] & 0xFFL) << 48;
        value |= ((long)block[offset++] & 0xFFL) << 40;
        value |= ((long)block[offset++] & 0xFFL) << 32;
        value |= ((long)block[offset++] & 0xFFL) << 24;
        value |= ((long)block[offset++] & 0xFFL) << 16;
        value |= ((long)block[offset++] & 0xFFL) << 8;
        return value |= (long)block[offset++] & 0xFFL;
    }
}

