/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.bytecode.compat.Box;
import com.caucho.db.Database;
import com.caucho.db.store.Block;
import com.caucho.db.store.BlockManager;
import com.caucho.db.store.Lock;
import com.caucho.db.store.StoreTransaction;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.RandomAccessStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Store {
    private static final Logger log = Log.open(Store._resin_compat_class_0());
    private static final L10N L = new L10N(Store._resin_compat_class_0());
    public static final int BLOCK_BITS = 16;
    public static final int BLOCK_SIZE = 65536;
    public static final int BLOCK_INDEX_MASK = 65535;
    public static final long BLOCK_MASK = -65536L;
    public static final long BLOCK_OFFSET_MASK = 65535L;
    public static final int ALLOC_FREE = 0;
    public static final int ALLOC_ROW = 1;
    public static final int ALLOC_USED = 2;
    public static final int ALLOC_FRAGMENT = 3;
    public static final int ALLOC_INDEX = 4;
    public static final int ALLOC_MASK = 15;
    public static final long FRAGMENT_CLOCK_MIN = 262144L;
    public static final int FRAGMENT_SIZE = 8192;
    public static final int FRAGMENT_PER_BLOCK = 7;
    public static final int STORE_CREATE_END = 1024;
    public static final int ALLOC_CHUNK_SIZE = 1024;
    protected final Database _database;
    protected final BlockManager _blockManager;
    private final String _name;
    private int _id;
    private Path _path;
    private boolean _isFlushDirtyBlocksOnCommit = true;
    private long _fileSize;
    private long _blockCount;
    private Object _allocationLock = new Object();
    private byte[] _allocationTable;
    private long _clockAddr;
    private long _fragmentClockAddr;
    private long _fragmentClockLastAddr;
    private long _fragmentClockTotal;
    private long _fragmentClockUsed;
    private final Object _statLock = new Object();
    private long _fragmentUseCount;
    private SoftReference<RandomAccessWrapper> _cachedRowFile;
    private Lock _tableLock;
    private final Lifecycle _lifecycle = new Lifecycle();
    private static Class _resin_compat_class_0;

    public Store(Database database, String name, Lock tableLock) {
        this(database, name, tableLock, database.getPath().lookup(new CharBuffer().append(name).append(".db").toString()));
    }

    public Store(Database database, String name, Lock tableLock, Path path) {
        this._database = database;
        this._blockManager = this._database.getBlockManager();
        this._name = name;
        this._path = path;
        this._id = this._blockManager.allocateStoreId();
        if (tableLock == null) {
            tableLock = new Lock(this._id);
        }
        this._tableLock = tableLock;
    }

    public static Store create(Path path) throws IOException, SQLException {
        Database db = new Database();
        db.init();
        Store store = new Store(db, "temp", null, path);
        if (path.canRead()) {
            store.init();
        } else {
            store.create();
        }
        return store;
    }

    public void setFlushDirtyBlocksOnCommit(boolean flushOnCommit) {
        this._isFlushDirtyBlocksOnCommit = flushOnCommit;
    }

    public boolean isFlushDirtyBlocksOnCommit() {
        return this._isFlushDirtyBlocksOnCommit;
    }

    public String getName() {
        return this._name;
    }

    public int getId() {
        return this._id;
    }

    public Lock getLock() {
        return this._tableLock;
    }

    public BlockManager getBlockManager() {
        return this._blockManager;
    }

    public long getFileSize() {
        return this._fileSize;
    }

    public long getBlockCount() {
        return this._blockCount;
    }

    static long blockIndexToAddr(long blockIndex) {
        return blockIndex << 16;
    }

    public final long blockIndexToBlockId(long blockIndex) {
        return (blockIndex << 16) + (long)this._id;
    }

    public final long addressToBlockId(long address) {
        return (address & 0xFFFFFFFFFFFF0000L) + (long)this._id;
    }

    public static long blockIdToAddress(long blockId) {
        return blockId & 0xFFFFFFFFFFFF0000L;
    }

    public static long blockIdToAddress(long blockId, int offset) {
        return (blockId & 0xFFFFFFFFFFFF0000L) + (long)offset;
    }

    public long getTotalFragmentSize() {
        return this._fragmentUseCount * 8192L;
    }

    public void create() throws IOException, SQLException {
        if (!this._lifecycle.toActive()) {
            return;
        }
        log.finer(new CharBuffer().append(this).append(" create").toString());
        this._path.getParent().mkdirs();
        if (this._path.exists()) {
            throw new SQLException(L.l("Table `{0}' already exists.  CREATE can not override an existing table.", this._name));
        }
        this._allocationTable = new byte[1024];
        this.setAllocation(0L, 2);
        this.setAllocation(1L, 2);
        byte[] buffer = new byte[65536];
        this.writeBlock(0L, buffer, 0, 65536);
        this.writeBlock(65536L, buffer, 0, 65536);
        this.writeBlock(0L, this._allocationTable, 0, this._allocationTable.length);
        this._blockCount = 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        if (!this._lifecycle.toActive()) {
            return;
        }
        log.finer(new CharBuffer().append(this).append(" init").toString());
        RandomAccessWrapper wrapper = this.openRowFile();
        try {
            RandomAccessStream file = wrapper.getFile();
            this._fileSize = file.getLength();
            this._blockCount = (this._fileSize + 65536L - 1L) / 65536L;
            int allocCount = (int)(this._blockCount / 2L) + 1024;
            allocCount -= allocCount % 1024;
            this._allocationTable = new byte[allocCount];
            for (int i = 0; i < allocCount; i += 65536) {
                int len = allocCount - i;
                if (65536 < len) {
                    len = 65536;
                }
                this.readBlock((long)i * 2L * 65536L, this._allocationTable, i, len);
            }
        }
        finally {
            wrapper.close();
        }
    }

    public void remove() throws SQLException {
        try {
            this._path.remove();
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    public long firstRow(long blockId) throws IOException {
        return this.firstBlock(blockId, 1);
    }

    public long firstFragment(long blockId) throws IOException {
        return this.firstBlock(blockId, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long firstBlock(long blockId, int type) throws IOException {
        if (blockId <= 65536L) {
            blockId = 65536L;
        }
        Object object = this._allocationLock;
        synchronized (object) {
            for (long blockIndex = blockId >> 16; blockIndex < this._blockCount; ++blockIndex) {
                if (this.getAllocation(blockIndex) != type) continue;
                return this.blockIndexToBlockId(blockIndex);
            }
        }
        return -1L;
    }

    public Block readBlockByAddress(long blockAddress) throws IOException {
        return this.readBlock(this.addressToBlockId(blockAddress));
    }

    public Block readBlock(long blockId) throws IOException {
        Block block = this._blockManager.getBlock(this, blockId);
        try {
            block.read();
            return block;
        }
        catch (IOException e) {
            block.free();
            throw e;
        }
        catch (RuntimeException e) {
            block.free();
            throw e;
        }
    }

    public Block allocateRow() throws IOException {
        return this.allocateBlock(1);
    }

    public Block allocateBlock() throws IOException {
        return this.allocateBlock(2);
    }

    private Block allocateFragmentBlock() throws IOException {
        return this.allocateBlock(3);
    }

    public Block allocateIndexBlock() throws IOException {
        return this.allocateBlock(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block allocateBlock(int code) throws IOException {
        long blockIndex;
        Object object = this._allocationLock;
        synchronized (object) {
            long end = this._blockCount;
            if ((long)(2 * this._allocationTable.length) < end) {
                end = 2 * this._allocationTable.length;
            }
            for (blockIndex = 0L; blockIndex < end && this.getAllocation(blockIndex) != 0; ++blockIndex) {
            }
            if ((long)(2 * this._allocationTable.length) <= blockIndex) {
                byte[] newTable = new byte[this._allocationTable.length + 1024];
                System.arraycopy(this._allocationTable, 0, newTable, 0, this._allocationTable.length);
                this._allocationTable = newTable;
                if (blockIndex % 131072L == 0L) {
                    this.setAllocation(blockIndex, 2);
                    ++blockIndex;
                }
            }
            this.setAllocation(blockIndex, 2);
            if (log.isLoggable(Level.FINE)) {
                log.fine(new CharBuffer().append(this).append(" allocating block ").append(blockIndex).toString());
            }
            if (this._blockCount <= blockIndex) {
                this._blockCount = blockIndex + 1L;
            }
        }
        long blockId = this.blockIndexToBlockId(blockIndex);
        Block block = this._blockManager.getBlock(this, blockId);
        byte[] buffer = block.getBuffer();
        for (int i = 65535; i >= 0; --i) {
            buffer[i] = 0;
        }
        block.setDirty(0, 65536);
        Object object2 = this._allocationLock;
        synchronized (object2) {
            this.setAllocation(blockIndex, code);
            this.saveAllocation();
        }
        return block;
    }

    protected void validateBlockId(long blockId) throws IllegalArgumentException, IllegalStateException {
        RuntimeException e = null;
        if (this.isClosed()) {
            e = new IllegalStateException(L.l("store {0} is closing.", this));
        } else if (this.getId() <= 0) {
            e = new IllegalStateException(L.l("invalid store {0}.", this));
        } else if ((long)this.getId() != (blockId & 0xFFFFL)) {
            e = new IllegalArgumentException(L.l("block {0} must match store {1}.", (Object)Box.boxLong(blockId & 0xFFFFL), this));
        }
        if (e != null) {
            throw e;
        }
    }

    protected void assertStoreActive() throws IllegalStateException {
        IllegalStateException e = null;
        if (this.isClosed()) {
            e = new IllegalStateException(L.l("store {0} is closing.", this));
        } else if (this.getId() <= 0) {
            e = new IllegalStateException(L.l("invalid store {0}.", this));
        }
        if (e != null) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeBlock(long blockId) throws IOException {
        if (blockId == 0L) {
            return;
        }
        Object object = this._allocationLock;
        synchronized (object) {
            this.setAllocation(blockId >> 16, 0);
        }
        this.saveAllocation();
    }

    public final int getAllocation(long blockIndex) {
        int allocOffset = (int)(blockIndex >> 1);
        int allocBits = 4 * (int)(blockIndex & 1L);
        return this._allocationTable[allocOffset] >> allocBits & 0xF;
    }

    private void setAllocation(long blockIndex, int code) {
        int allocOffset = (int)(blockIndex >> 1);
        int allocBits = 4 * (int)(blockIndex & 1L);
        int mask = 15 << allocBits;
        this._allocationTable[allocOffset] = (byte)(this._allocationTable[allocOffset] & ~mask | code << allocBits);
    }

    private void saveAllocation() throws IOException {
        int allocCount = this._allocationTable.length;
        for (int i = 0; i < allocCount; i += 65536) {
            int len = allocCount - i;
            if (65536 < len) {
                len = 65536;
            }
            this.writeBlock((long)i * 2L * 65536L, this._allocationTable, i, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readFragment(long fragmentAddress, int fragmentOffset, byte[] buffer, int offset, int length) throws IOException {
        if (8192 - fragmentOffset < length) {
            throw new IllegalArgumentException(L.l("read offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(fragmentAddress));
        try {
            byte[] blockBuffer;
            int blockOffset = this.getFragmentOffset(fragmentAddress);
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                System.arraycopy(blockBuffer, blockOffset + 1 + fragmentOffset, buffer, offset, length);
                // ** MonitorExit[var10_9] (shouldn't be in output)
                int n = length;
                return n;
            }
        }
        finally {
            block.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readFragment(long fragmentAddress, int fragmentOffset, char[] buffer, int offset, int length) throws IOException {
        if (8192 - fragmentOffset < 2 * length) {
            throw new IllegalArgumentException(L.l("read offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(fragmentAddress));
        try {
            byte[] blockBuffer;
            int blockOffset = this.getFragmentOffset(fragmentAddress) + 1;
            blockOffset += fragmentOffset;
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                for (int i = 0; i < length; ++i) {
                    int ch1 = blockBuffer[blockOffset] & 0xFF;
                    int ch2 = blockBuffer[blockOffset + 1] & 0xFF;
                    buffer[offset + i] = (char)((ch1 << 8) + ch2);
                    blockOffset += 2;
                }
                // ** MonitorExit[var10_9] (shouldn't be in output)
                int n = length;
                return n;
            }
        }
        finally {
            block.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readFragmentLong(long fragmentAddress, int fragmentOffset) throws IOException {
        Block block = this.readBlock(this.addressToBlockId(fragmentAddress));
        try {
            byte[] blockBuffer;
            int blockOffset = this.getFragmentOffset(fragmentAddress);
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                long l = Store.readLong(blockBuffer, fragmentOffset);
                // ** MonitorExit[var7_6] (shouldn't be in output)
                return l;
            }
        }
        finally {
            block.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long allocateFragment(StoreTransaction xa) throws IOException {
        boolean isLoop = false;
        while (true) {
            Block block = null;
            try {
                long freeBlockId = this.firstFragment(this._fragmentClockAddr);
                if (freeBlockId >= 0L) {
                    block = this.readBlock(freeBlockId);
                } else {
                    if (!isLoop && 262144L < this._fragmentClockTotal && 2L * this._fragmentClockUsed < this._fragmentClockTotal) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(new CharBuffer().append(this).append(" fragment loop total:").append(this._fragmentClockTotal).append(" used:").append(this._fragmentClockUsed).toString());
                        }
                        this._fragmentClockAddr = 0L;
                        this._fragmentClockLastAddr = 0L;
                        this._fragmentClockUsed = 0L;
                        this._fragmentClockTotal = 0L;
                        isLoop = true;
                        continue;
                    }
                    block = this.allocateFragmentBlock();
                    this._fragmentClockTotal += 57344L;
                }
                this._fragmentClockLastAddr = this._fragmentClockAddr = block.getBlockId();
                long fragAddr = this.allocateFragment(block);
                if (fragAddr != 0L) {
                    block = xa.createAutoCommitWriteBlock(block);
                    long l = fragAddr;
                    return l;
                }
            }
            finally {
                if (block == null) continue;
                block.free();
                continue;
            }
            this._fragmentClockAddr += 65536L;
            long nextBlockId = this.firstFragment(this._fragmentClockAddr);
            if (nextBlockId <= 0L) continue;
            this.updateClockUse(nextBlockId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateFragment(Block block) throws IOException {
        byte[] buffer;
        byte[] byArray = buffer = block.getBuffer();
        synchronized (buffer) {
            for (int i = 0; i < 7; ++i) {
                int offset = i * 8193;
                if (buffer[offset] != 0) continue;
                buffer[offset] = 1;
                block.setDirty(offset, offset + 1);
                Object object = this._statLock;
                synchronized (object) {
                    ++this._fragmentUseCount;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return Store.blockIdToAddress(block.getBlockId()) + (long)i;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClockUse(long blockAddr) throws IOException {
        Block block = this.readBlock(blockAddr);
        try {
            byte[] buffer = block.getBuffer();
            this._fragmentClockTotal += 57344L;
            byte[] byArray = buffer;
            synchronized (buffer) {
                for (int i = 0; i < 7; ++i) {
                    int offset = i * 8193;
                    if (buffer[offset] == 0) continue;
                    this._fragmentClockUsed += 8192L;
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
            }
        }
        finally {
            block.free();
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFragment(StoreTransaction xa, long fragmentAddress, int fragmentOffset, byte[] buffer, int offset, int length) throws IOException {
        if (8192 - fragmentOffset < length) {
            throw new IllegalArgumentException(L.l("write offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = xa.readBlock(this, this.addressToBlockId(fragmentAddress));
        try {
            block = xa.createAutoCommitWriteBlock(block);
            int blockOffset = this.getFragmentOffset(fragmentAddress);
            byte[] blockBuffer = block.getBuffer();
            blockOffset += 1 + fragmentOffset;
            byte[] byArray = blockBuffer;
            synchronized (blockBuffer) {
                System.arraycopy(buffer, offset, blockBuffer, blockOffset, length);
                block.setDirty(blockOffset, blockOffset + length);
                // ** MonitorExit[var11_10] (shouldn't be in output)
            }
        }
        finally {
            block.free();
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFragment(StoreTransaction xa, long fragmentAddress, int fragmentOffset, char[] buffer, int offset, int length) throws IOException {
        if (8192 - fragmentOffset < length) {
            throw new IllegalArgumentException(L.l("write offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = xa.readBlock(this, this.addressToBlockId(fragmentAddress));
        try {
            block = xa.createAutoCommitWriteBlock(block);
            int blockOffset = this.getFragmentOffset(fragmentAddress);
            byte[] blockBuffer = block.getBuffer();
            blockOffset += 1 + fragmentOffset;
            byte[] byArray = blockBuffer;
            synchronized (blockBuffer) {
                for (int i = 0; i < length; i += 2) {
                    char ch = buffer[offset + i];
                    blockBuffer[blockOffset + i] = (byte)(ch >> 8);
                    blockBuffer[blockOffset + i + 1] = (byte)ch;
                }
                block.setDirty(blockOffset, blockOffset + length);
                // ** MonitorExit[var11_10] (shouldn't be in output)
            }
        }
        finally {
            block.free();
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFragmentLong(StoreTransaction xa, long fragmentAddress, int fragmentOffset, long value) throws IOException {
        Block block = xa.readBlock(this, this.addressToBlockId(fragmentAddress));
        try {
            block = xa.createAutoCommitWriteBlock(block);
            int blockOffset = this.getFragmentOffset(fragmentAddress);
            byte[] blockBuffer = block.getBuffer();
            int offset = blockOffset + 1 + fragmentOffset;
            byte[] byArray = blockBuffer;
            synchronized (blockBuffer) {
                Store.writeLong(blockBuffer, offset, value);
                block.setDirty(offset, offset + 8);
                // ** MonitorExit[var11_9] (shouldn't be in output)
            }
        }
        finally {
            block.free();
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFragment(StoreTransaction xa, long fragmentAddress) throws IOException {
        Block block = xa.readBlock(this, this.addressToBlockId(fragmentAddress));
        try {
            byte[] blockBuffer;
            block = xa.createAutoCommitWriteBlock(block);
            int fragOffset = this.getFragmentOffset(fragmentAddress);
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                blockBuffer[fragOffset] = 0;
                // ** MonitorExit[var7_7] (shouldn't be in output)
                block.setDirty(fragOffset, fragOffset + 1);
            }
        }
        finally {
            block.free();
        }
        {
            Object object = this._statLock;
            synchronized (object) {
                --this._fragmentUseCount;
            }
            return;
        }
    }

    private int getFragmentOffset(long fragmentAddress) {
        int id = (int)(fragmentAddress & 0xFFFFL);
        return 8193 * id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBlock(long blockId, byte[] buffer, int offset, int length) throws IOException {
        RandomAccessWrapper wrapper = this.openRowFile();
        RandomAccessStream is = wrapper.getFile();
        long blockAddress = blockId & 0xFFFFFFFFFFFF0000L;
        try {
            int readLen = is.read(blockAddress, buffer, offset, length);
            if (readLen < 0) {
                for (int i = 0; i < 65536; ++i) {
                    buffer[i] = 0;
                }
            }
            this.freeRowFile(wrapper);
            wrapper = null;
        }
        finally {
            if (wrapper != null) {
                wrapper.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlock(long blockAddress, byte[] buffer, int offset, int length) throws IOException {
        RandomAccessWrapper wrapper = this.openRowFile();
        RandomAccessStream os = wrapper.getFile();
        try {
            os.write(blockAddress, buffer, offset, length);
            this.freeRowFile(wrapper);
            wrapper = null;
            if (this._fileSize < blockAddress + (long)length) {
                this._fileSize = blockAddress + (long)length;
            }
        }
        finally {
            if (wrapper != null) {
                wrapper.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessWrapper openRowFile() throws IOException {
        RandomAccessStream file = null;
        RandomAccessWrapper wrapper = null;
        Store store = this;
        synchronized (store) {
            SoftReference<RandomAccessWrapper> ref = this._cachedRowFile;
            this._cachedRowFile = null;
            if (ref != null) {
                wrapper = ref.get();
            }
        }
        if (wrapper != null) {
            file = wrapper.getFile();
        }
        if (file == null) {
            file = this._path.openRandomAccess();
            wrapper = new RandomAccessWrapper(file);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeRowFile(RandomAccessWrapper wrapper) throws IOException {
        Store store = this;
        synchronized (store) {
            if (this._cachedRowFile == null) {
                this._cachedRowFile = new SoftReference<RandomAccessWrapper>(wrapper);
                return;
            }
        }
        wrapper.close();
    }

    private static void writeShort(byte[] buffer, int offset, int v) {
        buffer[offset + 0] = (byte)(v >> 8);
        buffer[offset + 1] = (byte)v;
    }

    private static int readShort(byte[] buffer, int offset) {
        return (buffer[offset + 0] & 0xFF) << 8 | buffer[offset + 1] & 0xFF;
    }

    public void flush() {
        if (this._lifecycle.isActive() && this._blockManager != null) {
            this._blockManager.flush(this);
        }
    }

    public boolean isClosed() {
        return this._lifecycle.isDestroyed();
    }

    public void close() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        log.finer(new CharBuffer().append(this).append(" closing").toString());
        if (this._blockManager != null) {
            this._blockManager.freeStore(this);
            this._blockManager.freeStoreId(this._id);
        }
        long id = this._id;
        this._id = 0;
        this._path = null;
        RandomAccessWrapper wrapper = null;
        SoftReference<RandomAccessWrapper> ref = this._cachedRowFile;
        this._cachedRowFile = null;
        if (ref != null) {
            wrapper = ref.get();
        }
        if (wrapper != null) {
            try {
                wrapper.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    public byte[] getAllocationTable() {
        byte[] table = new byte[this._allocationTable.length];
        System.arraycopy(this._allocationTable, 0, table, 0, table.length);
        return table;
    }

    private static IllegalStateException stateError(String msg) {
        IllegalStateException e = new IllegalStateException(msg);
        e.fillInStackTrace();
        log.log(Level.WARNING, e.toString(), e);
        return e;
    }

    public static long readLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
    }

    public static void writeLong(byte[] buffer, int offset, long v) {
        buffer[offset + 0] = (byte)(v >> 56);
        buffer[offset + 1] = (byte)(v >> 48);
        buffer[offset + 2] = (byte)(v >> 40);
        buffer[offset + 3] = (byte)(v >> 32);
        buffer[offset + 4] = (byte)(v >> 24);
        buffer[offset + 5] = (byte)(v >> 16);
        buffer[offset + 6] = (byte)(v >> 8);
        buffer[offset + 7] = (byte)v;
    }

    public String toString() {
        return new CharBuffer().append("Store[").append(this._id).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.store.Store");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class RandomAccessWrapper {
        private RandomAccessStream _file;

        RandomAccessWrapper(RandomAccessStream file) {
            this._file = file;
        }

        RandomAccessStream getFile() {
            return this._file;
        }

        void close() throws IOException {
            RandomAccessStream file = this._file;
            this._file = null;
            if (file != null) {
                file.close();
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.close();
        }
    }
}

