/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.store.BlobInputStream;
import com.caucho.db.store.BlobOutputStream;
import com.caucho.db.store.ClobReader;
import com.caucho.db.store.ClobWriter;
import com.caucho.db.store.RawTransaction;
import com.caucho.db.store.Store;
import com.caucho.db.store.StoreTransaction;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.OutputStreamWithBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Inode {
    private static final L10N L = new L10N(Inode._resin_compat_class_0());
    private static final Logger log = Log.open(Inode._resin_compat_class_0());
    public static final int INODE_SIZE = 128;
    public static final int INLINE_BLOB_SIZE = 120;
    public static final int INODE_BLOCK_SIZE = 8192;
    public static final int INDIRECT_BLOCKS = 1024;
    public static final int DIRECT_BLOCKS = 14;
    public static final int SINGLE_INDIRECT_BLOCKS = 512;
    public static final int DOUBLE_INDIRECT_BLOCKS = 128;
    public static final int TRIPLE_INDIRECT_BLOCKS = 128;
    public static final int QUAD_INDIRECT_BLOCKS = 128;
    public static final int PENTA_INDIRECT_BLOCKS = 128;
    private static final byte[] NULL_BYTES = new byte[128];
    private Store _store;
    private StoreTransaction _xa;
    private byte[] _bytes = new byte[128];
    private static Class _resin_compat_class_0;

    public Inode() {
    }

    public Inode(Store store, StoreTransaction xa) {
        this._store = store;
        this._xa = xa;
    }

    public Inode(Store store) {
        this(store, RawTransaction.create());
    }

    public Store getStore() {
        return this._store;
    }

    public byte[] getBuffer() {
        return this._bytes;
    }

    public long getLength() {
        return Inode.readLong(this._bytes, 0);
    }

    public void init(Store store, StoreTransaction xa, byte[] buffer, int offset) {
        this._store = store;
        this._xa = xa;
        System.arraycopy(buffer, offset, this._bytes, 0, this._bytes.length);
    }

    public InputStream openInputStream() {
        return new BlobInputStream(this);
    }

    public void writeToStream(OutputStreamWithBuffer os) throws IOException {
        this.writeToStream(os, 0L, 0x3FFFFFFFFFFFFFFFL);
    }

    public void writeToStream(OutputStreamWithBuffer os, long offset, long length) throws IOException {
        byte[] buffer = os.getBuffer();
        int writeLength = buffer.length;
        int writeOffset = os.getBufferOffset();
        while (length > 0L) {
            int len;
            int sublen = writeLength - writeOffset;
            if (sublen == 0) {
                buffer = os.nextBuffer(writeOffset);
                writeOffset = os.getBufferOffset();
                sublen = writeLength - writeOffset;
            }
            if (length < (long)sublen) {
                sublen = (int)length;
            }
            if ((len = Inode.read(this._bytes, 0, this._store, offset, buffer, writeOffset, sublen)) <= 0) break;
            writeOffset += len;
            offset += (long)len;
            length -= (long)len;
        }
        os.setBufferOffset(writeOffset);
    }

    static int read(byte[] inode, int inodeOffset, Store store, long fileOffset, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        int sublen;
        long fileLength = Inode.readLong(inode, inodeOffset);
        if (fileLength - fileOffset < (long)(sublen = bufferLength)) {
            sublen = (int)(fileLength - fileOffset);
        }
        if (sublen <= 0) {
            return -1;
        }
        if (fileLength <= 120L) {
            System.arraycopy(inode, inodeOffset + 8 + (int)fileOffset, buffer, bufferOffset, sublen);
            return sublen;
        }
        long fragAddr = Inode.readFragmentAddr(inode, inodeOffset, store, fileOffset);
        int fragOffset = (int)(fileOffset % 8192L);
        if (8192 - fragOffset < sublen) {
            sublen = 8192 - fragOffset;
        }
        store.readFragment(fragAddr, fragOffset, buffer, bufferOffset, sublen);
        return sublen;
    }

    static void append(byte[] inode, int inodeOffset, Store store, StoreTransaction xa, byte[] buffer, int offset, int length) throws IOException {
        long currentLength = Inode.readLong(inode, inodeOffset);
        long newLength = currentLength + (long)length;
        Inode.writeLong(inode, inodeOffset, newLength);
        if (newLength <= 120L) {
            System.arraycopy(buffer, offset, inode, (int)((long)(inodeOffset + 8) + currentLength), length);
        } else {
            if (currentLength % 8192L != 0L) {
                long fragAddr = Inode.readFragmentAddr(inode, inodeOffset, store, currentLength);
                int fragOffset = (int)(currentLength % 8192L);
                int sublen = length;
                if (8192 - fragOffset < sublen) {
                    sublen = 8192 - fragOffset;
                }
                store.writeFragment(xa, fragAddr, fragOffset, buffer, offset, sublen);
                offset += sublen;
                length -= sublen;
                currentLength += (long)sublen;
            }
            while (length > 0) {
                int sublen = length;
                if (8192 < sublen) {
                    sublen = 8192;
                }
                long fragAddr = store.allocateFragment(xa);
                Inode.writeFragmentAddr(inode, inodeOffset, store, xa, currentLength, fragAddr);
                store.writeFragment(xa, fragAddr, 0, buffer, offset, sublen);
                offset += sublen;
                length -= sublen;
                currentLength += (long)sublen;
            }
        }
    }

    static int read(byte[] inode, int inodeOffset, Store store, long fileOffset, char[] buffer, int bufferOffset, int bufferLength) throws IOException {
        int sublen;
        long fileLength = Inode.readLong(inode, inodeOffset);
        if (fileLength - fileOffset < (long)(2 * (sublen = bufferLength))) {
            sublen = (int)(fileLength - fileOffset) / 2;
        }
        if (sublen <= 0) {
            return -1;
        }
        if (fileLength <= 120L) {
            int baseOffset = inodeOffset + 8 + (int)fileOffset;
            for (int i = 0; i < sublen; i += 2) {
                char ch;
                buffer[bufferOffset + i] = ch = (char)(((inode[baseOffset + i] & 0xFF) << 8) + (inode[baseOffset + i + 1] & 0xFF));
            }
            return sublen;
        }
        long fragAddr = Inode.readFragmentAddr(inode, inodeOffset, store, fileOffset);
        int fragOffset = (int)(fileOffset % 8192L);
        if (8192 - fragOffset < 2 * sublen) {
            sublen = (8192 - fragOffset) / 2;
        }
        store.readFragment(fragAddr, fragOffset, buffer, bufferOffset, sublen);
        return sublen;
    }

    static void append(byte[] inode, int inodeOffset, Store store, StoreTransaction xa, char[] buffer, int offset, int length) throws IOException {
        long currentLength = Inode.readLong(inode, inodeOffset);
        long newLength = currentLength + (long)length;
        Inode.writeLong(inode, inodeOffset, newLength);
        if (newLength <= 120L) {
            int writeOffset = (int)((long)(inodeOffset + 8) + currentLength);
            for (int i = 0; i < length; ++i) {
                char ch = buffer[offset + i];
                inode[writeOffset++] = (byte)(ch >> 8);
                inode[writeOffset++] = (byte)ch;
            }
        } else {
            if (currentLength % 8192L != 0L) {
                long fragAddr = Inode.readFragmentAddr(inode, inodeOffset, store, currentLength);
                int fragOffset = (int)(currentLength % 8192L);
                int sublen = 2 * length;
                if (8192 - fragOffset < sublen) {
                    sublen = 8192 - fragOffset;
                }
                store.writeFragment(xa, fragAddr, fragOffset, buffer, offset, sublen);
                offset += sublen / 2;
                length -= sublen / 2;
                currentLength += (long)sublen;
            }
            while (length > 0) {
                int sublen = 2 * length;
                if (8192 < sublen) {
                    sublen = 8192;
                }
                long fragAddr = store.allocateFragment(xa);
                Inode.writeFragmentAddr(inode, inodeOffset, store, xa, currentLength, fragAddr);
                store.writeFragment(xa, fragAddr, 0, buffer, offset, sublen);
                offset += sublen / 2;
                length -= sublen / 2;
                currentLength += (long)sublen;
            }
        }
    }

    public OutputStream openOutputStream() {
        return new BlobOutputStream(this);
    }

    void closeOutputStream() {
    }

    public Reader openReader() {
        return new ClobReader(this);
    }

    public Writer openWriter() {
        return new ClobWriter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        byte[] byArray = this._bytes;
        synchronized (this._bytes) {
            byte[] bytes = this._bytes;
            try {
                long length;
                if (length <= 120L || bytes == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                for (length = Inode.readLong(this._bytes, 0); length > 0L; length -= 8192L) {
                    long fragAddr = Inode.readFragmentAddr(bytes, 0, this._store, length - 1L);
                    if ((fragAddr & 0xFFFFFFFFFFFF0000L) == 0L) {
                        String msg = new CharBuffer().append(this._store).append(": inode block ").append(length).append(" has 0 fragment").toString();
                        throw Inode.stateError(msg);
                    }
                    this._store.deleteFragment(this._xa, fragAddr);
                    int fragCount = (int)((length - 1L) / 8192L);
                    int dblFragCount = fragCount - 14 - 512;
                    if (dblFragCount >= 0 && dblFragCount % 1024 == 0) {
                        fragAddr = Inode.readLong(bytes, 120);
                        int dblIndex = fragCount / 1024;
                        if ((fragAddr = this._store.readFragmentLong(fragAddr, dblIndex)) != 0L) {
                            this._store.deleteFragment(this._xa, fragAddr);
                        }
                    }
                    if (fragCount != 14 || (fragAddr = Inode.readLong(bytes, 120)) == 0L) continue;
                    this._store.deleteFragment(this._xa, fragAddr);
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            finally {
                System.arraycopy(NULL_BYTES, 0, this._bytes, 0, NULL_BYTES.length);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static void clear(byte[] inode, int inodeOffset) {
        int end = inodeOffset + 128;
        while (inodeOffset < end) {
            inode[inodeOffset] = 0;
            ++inodeOffset;
        }
    }

    static long readFragmentAddr(byte[] inode, int inodeOffset, Store store, long fileOffset) throws IOException {
        long fragCount = fileOffset / 8192L;
        if (fragCount < 14L) {
            return Inode.readLong(inode, (int)((long)inodeOffset + 8L * (1L + fragCount)));
        }
        if (fragCount < 526L) {
            long indirectAddr = Inode.readLong(inode, inodeOffset + 120);
            if (indirectAddr == 0L) {
                throw new IllegalStateException(L.l("null block id"));
            }
            int offset = (int)(8L * (fragCount - 14L));
            return store.readFragmentLong(indirectAddr, offset);
        }
        if (fragCount < 131598L) {
            long indirectAddr = Inode.readLong(inode, inodeOffset + 120);
            if (indirectAddr == 0L) {
                throw new IllegalStateException(L.l("null block id"));
            }
            int index = (int)((fragCount -= 526L) / 1024L);
            long doubleIndirectAddr = store.readFragmentLong(indirectAddr, index);
            int offset = (int)(8L * (fragCount % 1024L));
            return store.readFragmentLong(doubleIndirectAddr, offset);
        }
        throw new IllegalStateException(L.l("Can't yet support data over 64M"));
    }

    private static void writeFragmentAddr(byte[] inode, int offset, Store store, StoreTransaction xa, long fragLength, long fragAddr) throws IOException {
        int fragCount = (int)(fragLength / 8192L);
        if ((fragAddr & 0xFFFFFFFFFFFF0000L) == 0L) {
            String msg = new CharBuffer().append(store).append(": inode block ").append(fragCount).append(" writing 0 fragment").toString();
            throw Inode.stateError(msg);
        }
        if (fragCount < 14) {
            Inode.writeLong(inode, offset + (fragCount + 1) * 8, fragAddr);
        } else if (fragCount < 526) {
            long indAddr = Inode.readLong(inode, offset + 120);
            if (indAddr == 0L) {
                indAddr = store.allocateFragment(xa);
                Inode.writeLong(inode, offset + 120, indAddr);
            }
            int fragOffset = 8 * (fragCount - 14);
            store.writeFragmentLong(xa, indAddr, fragOffset, fragAddr);
        } else if (fragCount < 131598) {
            int count;
            int dblIndCount;
            long dblIndAddr;
            long indAddr = Inode.readLong(inode, offset + 120);
            if (indAddr == 0L) {
                indAddr = store.allocateFragment(xa);
                Inode.writeLong(inode, offset + 120, indAddr);
            }
            if ((dblIndAddr = store.readFragmentLong(indAddr, (dblIndCount = (count = fragCount - 14 - 512) / 1024) * 8)) == 0L) {
                dblIndAddr = store.allocateFragment(xa);
                store.writeFragmentLong(xa, indAddr, dblIndCount * 8, dblIndAddr);
            }
            int fragOffset = 8 * (count % 1024);
            store.writeFragmentLong(xa, dblIndAddr, fragOffset, fragAddr);
        } else {
            throw new IllegalStateException(L.l("Can't yet support data over 64M"));
        }
    }

    public static long readLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
    }

    public static void writeLong(byte[] buffer, int offset, long v) {
        buffer[offset + 0] = (byte)(v >> 56);
        buffer[offset + 1] = (byte)(v >> 48);
        buffer[offset + 2] = (byte)(v >> 40);
        buffer[offset + 3] = (byte)(v >> 32);
        buffer[offset + 4] = (byte)(v >> 24);
        buffer[offset + 5] = (byte)(v >> 16);
        buffer[offset + 6] = (byte)(v >> 8);
        buffer[offset + 7] = (byte)v;
    }

    private static int readShort(byte[] buffer, int offset) {
        return ((buffer[offset + 0] & 0xFF) << 8) + (buffer[offset + 1] & 0xFF);
    }

    private static void writeShort(byte[] buffer, int offset, int v) {
        buffer[offset + 0] = (byte)(v >> 8);
        buffer[offset + 1] = (byte)v;
    }

    private static IllegalStateException stateError(String msg) {
        IllegalStateException e = new IllegalStateException(msg);
        e.fillInStackTrace();
        log.log(Level.WARNING, e.toString(), e);
        return e;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.store.Inode");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

