/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.store.Inode;
import com.caucho.db.store.RawTransaction;
import com.caucho.db.store.Store;
import com.caucho.db.store.StoreTransaction;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.Writer;

class ClobWriter
extends Writer {
    private Store _store;
    private StoreTransaction _xa;
    private TempBuffer _tempBuffer;
    private byte[] _buffer;
    private int _offset;
    private int _bufferEnd;
    private long _length;
    private Inode _inode;
    private byte[] _inodeBuffer;
    private int _inodeOffset;

    ClobWriter(StoreTransaction xa, Store store, byte[] inode, int inodeOffset) {
        this.init(xa, store, inode, inodeOffset);
    }

    ClobWriter(Inode inode) {
        this.init(null, inode.getStore(), inode.getBuffer(), 0);
        this._inode = inode;
    }

    public void init(StoreTransaction xa, Store store, byte[] inode, int inodeOffset) {
        if (xa == null) {
            xa = RawTransaction.create();
        }
        this._xa = xa;
        this._store = store;
        this._length = 0L;
        this._inodeBuffer = inode;
        this._inodeOffset = inodeOffset;
        Inode.clear(this._inodeBuffer, this._inodeOffset);
        this._offset = 0;
        this._tempBuffer = TempBuffer.allocate();
        this._buffer = this._tempBuffer.getBuffer();
        this._bufferEnd = this._buffer.length;
    }

    public void write(int v) throws IOException {
        if (this._bufferEnd <= this._offset) {
            this.flushBlock();
        }
        this._buffer[this._offset++] = (byte)(v >> 8);
        this._buffer[this._offset++] = (byte)v;
        this._length += 2L;
    }

    public void write(char[] buffer, int offset, int length) throws IOException {
        byte[] byteBuffer = this._buffer;
        int byteOffset = this._offset;
        while (length > 0) {
            int sublen;
            if (this._bufferEnd <= byteOffset) {
                this._offset = byteOffset;
                this.flushBlock();
                byteOffset = this._offset;
            }
            if (length < (sublen = this._bufferEnd - byteOffset >> 1)) {
                sublen = length;
            }
            for (int i = 0; i < sublen; ++i) {
                char ch = buffer[offset + i];
                byteBuffer[byteOffset++] = (byte)(ch >> 8);
                byteBuffer[byteOffset++] = (byte)ch;
            }
            offset += sublen;
            length -= sublen;
            this._length += (long)(2 * sublen);
        }
        this._offset = byteOffset;
    }

    private void flushBlock() throws IOException {
        int length = this._offset;
        this._offset = 0;
        Inode.append(this._inodeBuffer, this._inodeOffset, this._store, this._xa, this._buffer, 0, length);
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.flushBlock();
            TempBuffer.free(this._tempBuffer);
        }
        finally {
            if (this._inode != null) {
                this._inode.closeOutputStream();
            }
        }
    }

    private static void writeLong(byte[] buffer, int offset, long v) {
        buffer[offset + 0] = (byte)(v >> 56);
        buffer[offset + 1] = (byte)(v >> 48);
        buffer[offset + 2] = (byte)(v >> 40);
        buffer[offset + 3] = (byte)(v >> 32);
        buffer[offset + 4] = (byte)(v >> 24);
        buffer[offset + 5] = (byte)(v >> 16);
        buffer[offset + 6] = (byte)(v >> 8);
        buffer[offset + 7] = (byte)v;
    }

    private static long readLong(byte[] buffer, int offset) {
        return ((long)buffer[offset + 0] & 0xFFL) << 56 | ((long)buffer[offset + 1] & 0xFFL) << 48 | ((long)buffer[offset + 2] & 0xFFL) << 40 | ((long)buffer[offset + 3] & 0xFFL) << 32 | ((long)buffer[offset + 4] & 0xFFL) << 24 | ((long)buffer[offset + 4] & 0xFFL) << 16 | ((long)buffer[offset + 4] & 0xFFL) << 8 | (long)buffer[offset + 4] & 0xFFL;
    }

    private static void writeShort(byte[] buffer, int offset, short v) {
        buffer[offset + 0] = (byte)(v >> 8);
        buffer[offset + 1] = (byte)v;
    }

    private static int readShort(byte[] buffer, int offset) {
        return (buffer[offset + 0] & 0xFF) << 8 | buffer[offset + 1] & 0xFF;
    }
}

