/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.store.Block;
import com.caucho.db.store.ReadBlock;
import com.caucho.db.store.Store;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.util.LongKeyLruCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockManager {
    private static final Logger log = Log.open(BlockManager._resin_compat_class_0());
    private static final L10N L = new L10N(BlockManager._resin_compat_class_0());
    private static BlockManager _staticManager;
    private final byte[] _storeMask = new byte[8192];
    private final LongKeyLruCache<Block> _blockCache;
    private static Class _resin_compat_class_0;

    private BlockManager(int capacity) {
        this._blockCache = new LongKeyLruCache(capacity);
        this._storeMask[0] = (byte)(this._storeMask[0] | 1);
    }

    public static synchronized BlockManager create(int minEntries) {
        if (_staticManager == null) {
            _staticManager = new BlockManager(minEntries);
        }
        _staticManager.ensureCapacity(minEntries);
        return _staticManager;
    }

    public void ensureCapacity(int minCapacity) {
        this._blockCache.ensureCapacity(minCapacity);
    }

    public synchronized int allocateStoreId() {
        for (int i = 0; i < this._storeMask.length; ++i) {
            byte mask = this._storeMask[i];
            if (mask == 255) continue;
            for (int j = 0; j < 8; ++j) {
                if ((mask & 1 << j) != 0) continue;
                int n = i;
                this._storeMask[n] = (byte)(this._storeMask[n] | 1 << j);
                return 8 * i + j;
            }
        }
        throw new IllegalStateException(L.l("All store ids used."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Store store) {
        Block block;
        ArrayList<Block> dirtyBlocks = null;
        BlockManager blockManager = this;
        synchronized (blockManager) {
            Iterator<Block> values = this._blockCache.values();
            while (values.hasNext()) {
                block = values.next();
                if (block == null || block.getStore() != store || !block.isDirty()) continue;
                if (dirtyBlocks == null) {
                    dirtyBlocks = new ArrayList<Block>();
                }
                dirtyBlocks.add(block);
            }
        }
        for (int i = 0; dirtyBlocks != null && i < dirtyBlocks.size(); ++i) {
            Block block2 = (Block)dirtyBlocks.get(i);
            try {
                block = block2;
                synchronized (block) {
                    if (block2.isDirty()) {
                        block2.write();
                    }
                    continue;
                }
            }
            catch (IOException e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeStore(Store store) {
        ArrayList<Block> removeBlocks = new ArrayList<Block>();
        BlockManager blockManager = this;
        synchronized (blockManager) {
            Iterator<Block> iter = this._blockCache.values();
            while (iter.hasNext()) {
                Block block = iter.next();
                if (block == null || block.getStore() != store) continue;
                removeBlocks.add(block);
            }
        }
        Iterator i$ = removeBlocks.iterator();
        while (i$.hasNext()) {
            Block block = (Block)i$.next();
            this._blockCache.remove(block.getBlockId());
        }
    }

    public synchronized void freeStoreId(int storeId) {
        if (storeId <= 0) {
            throw new IllegalArgumentException(String.valueOf(storeId));
        }
        int n = storeId / 8;
        this._storeMask[n] = (byte)(this._storeMask[n] & ~(1 << storeId % 8));
    }

    synchronized Block getBlock(Store store, long blockId) {
        Block block = this._blockCache.get(blockId);
        if (block != null) {
            if (block.allocate()) {
                return block;
            }
            System.out.println("NO-ALLOC:");
            block = null;
        }
        if ((blockId & 0xFFFFFFFFFFFF0000L) == 0L) {
            throw BlockManager.stateError(L.l("Block 0 is reserved."));
        }
        block = new ReadBlock(store, blockId);
        block.allocate();
        this._blockCache.put(blockId, block);
        return block;
    }

    public long getHitCount() {
        return this._blockCache.getHitCount();
    }

    public long getMissCount() {
        return this._blockCache.getMissCount();
    }

    private static IllegalStateException stateError(String msg) {
        IllegalStateException e = new IllegalStateException(msg);
        e.fillInStackTrace();
        log.log(Level.WARNING, e.toString(), e);
        return e;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.store.BlockManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

