/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.Database;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SetItem;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;
import java.util.logging.Logger;

class UpdateQuery
extends Query {
    private static final Logger log = Log.open(UpdateQuery._resin_compat_class_0());
    private final Table _table;
    private SetItem[] _setItems;
    private static Class _resin_compat_class_0;

    UpdateQuery(Database db, String sql, Table table) throws SQLException {
        super(db, sql, null);
        this._table = table;
        this.setFromItems(new FromItem[]{new FromItem(table, table.getName())});
    }

    public void setSetItems(SetItem[] setItems) {
        this._setItems = setItems;
    }

    protected void bind() throws SQLException {
        super.bind();
        for (int i = 0; i < this._setItems.length; ++i) {
            Expr expr = this._setItems[i].getExpr();
            expr = expr.bind(this);
            this._setItems[i].setExpr(expr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(QueryContext context, Transaction xa) throws SQLException {
        int count = 0;
        SetItem[] setItems = this._setItems;
        TableIterator[] rows = new TableIterator[]{this._table.createTableIterator()};
        context.init(xa, rows);
        if (xa.isAutoCommit()) {
            xa.lockAutoCommitWrite(this._table.getLock());
        } else {
            xa.lockWrite(this._table.getLock());
        }
        boolean isOkay = false;
        try {
            if (!this.start(rows, rows.length, context, xa)) {
                isOkay = true;
                return;
            }
            do {
                for (int i = 0; i < setItems.length; ++i) {
                    Column column = setItems[i].getColumn();
                    Expr expr = setItems[i].getExpr();
                    TableIterator iter = rows[0];
                    column.set(xa, iter, expr, context);
                }
                context.setRowUpdateCount(++count);
            } while (this.nextTuple(rows, rows.length, context, xa));
            isOkay = true;
        }
        finally {
            this.freeRows(rows, rows.length);
            if (xa.isAutoCommit()) {
                xa.commitAutoCommitWrite(this._table.getLock());
            }
        }
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("UpdateQuery[");
        if (this._whereExpr != null) {
            cb.append(new CharBuffer().append(",where:").append(this._whereExpr).toString());
        }
        cb.append("]");
        return cb.close();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.UpdateQuery");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

