/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Data;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectQuery;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.sql.SubSelectParamExpr;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubSelectExpr
extends Expr {
    protected static final L10N L = new L10N(SubSelectExpr._resin_compat_class_0());
    private static final Logger log = Log.open(SubSelectExpr._resin_compat_class_0());
    private int _groupIndex;
    private SelectQuery _subselect;
    private Query _parentQuery;
    private static Class _resin_compat_class_0;

    SubSelectExpr(SelectQuery query) {
        this._subselect = query;
    }

    public SelectQuery getSubSelect() {
        return this._subselect;
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        if (this._parentQuery != null) {
            return this;
        }
        this._parentQuery = query;
        this._groupIndex = query.getDataFields();
        query.setDataFields(this._groupIndex + 1);
        this._subselect.bind();
        return this;
    }

    @Override
    public Class getType() {
        return this._subselect.getType();
    }

    ArrayList<SubSelectParamExpr> getParamExprs() {
        return this._subselect.getParamExprs();
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        ArrayList<SubSelectParamExpr> paramExprs = this.getParamExprs();
        long cost = 10L;
        for (int i = 0; i < paramExprs.size(); ++i) {
            cost += paramExprs.get(i).getExpr().cost(fromList);
        }
        return 2L * cost;
    }

    void evaluate(QueryContext context) throws SQLException {
        QueryContext subcontext = QueryContext.allocate();
        ArrayList<SubSelectParamExpr> paramExprs = this.getParamExprs();
        for (int i = 0; i < paramExprs.size(); ++i) {
            paramExprs.get(i).eval(context, subcontext);
        }
        this._subselect.execute(subcontext, context.getTransaction());
        SelectResult result = subcontext.getResult();
        Data data = context.getGroupData(this._groupIndex);
        if (result.next()) {
            Class type = this._subselect.getType();
            if (Long.TYPE.equals(type)) {
                data.setLong(result.getLong(0));
            } else {
                data.setString(result.getString(0));
            }
        } else {
            data.clear();
        }
        result.close();
        QueryContext.free(subcontext);
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        Data data = context.getGroupData(this._groupIndex);
        return data.getString();
    }

    public String toString() {
        return new CharBuffer().append("SubSelectExpr[").append(this._subselect).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.SubSelectExpr");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

