/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.jdbc.GeneratedKeysResultSet;
import com.caucho.db.sql.Data;
import com.caucho.db.sql.GroupItem;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.caucho.util.FreeList;
import com.caucho.util.NullIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryContext {
    private static final Logger log = Log.open(QueryContext._resin_compat_class_0());
    private static final FreeList<QueryContext> _freeList = new FreeList(64);
    private Transaction _xa;
    private TableIterator[] _tableIterators;
    private Data[] _parameters = new Data[8];
    private GroupItem _tempGroupItem;
    private GroupItem _groupItem;
    private boolean _isReturnGeneratedKeys;
    private SelectResult _result;
    private GeneratedKeysResultSet _generatedKeys;
    private int _rowUpdateCount;
    private HashMap<GroupItem, GroupItem> _groupMap;
    private byte[] _buffer = new byte[256];
    private static Class _resin_compat_class_0;

    private QueryContext() {
        this._tempGroupItem = GroupItem.allocate(new boolean[8]);
    }

    public static QueryContext allocate() {
        QueryContext queryContext = _freeList.allocate();
        if (queryContext == null) {
            queryContext = new QueryContext();
        }
        queryContext.clearParameters();
        return queryContext;
    }

    public void clearParameters() {
        for (int i = this._parameters.length - 1; i >= 0; --i) {
            if (this._parameters[i] == null) {
                this._parameters[i] = new Data();
            }
            this._parameters[i].clear();
        }
    }

    public void init(Transaction xa, TableIterator[] tableIterators) {
        this._xa = xa;
        this._tableIterators = tableIterators;
        this._rowUpdateCount = 0;
        this._groupItem = this._tempGroupItem;
        this._groupItem.init(0, null);
    }

    public void initGroup(int size, boolean[] isGroupByFields) {
        this._groupItem = this._tempGroupItem;
        this._groupItem.init(size, isGroupByFields);
        if (this._groupMap == null) {
            this._groupMap = new HashMap();
        }
    }

    public void selectGroup() {
        GroupItem item = this._groupMap.get(this._groupItem);
        if (item == null) {
            item = this._groupItem.allocateCopy();
            this._groupMap.put(item, item);
        }
        this._groupItem = item;
    }

    Iterator<GroupItem> groupResults() {
        if (this._groupMap == null) {
            return NullIterator.create();
        }
        Iterator<GroupItem> results = this._groupMap.values().iterator();
        this._groupMap = null;
        return results;
    }

    void setGroupItem(GroupItem item) {
        this._groupItem = item;
    }

    public TableIterator[] getTableIterators() {
        return this._tableIterators;
    }

    public void setTransaction(Transaction xa) {
        this._xa = xa;
    }

    public Transaction getTransaction() {
        return this._xa;
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    public int getRowUpdateCount() {
        return this._rowUpdateCount;
    }

    public void setRowUpdateCount(int count) {
        this._rowUpdateCount = count;
    }

    public boolean isReturnGeneratedKeys() {
        return this._isReturnGeneratedKeys;
    }

    public void setReturnGeneratedKeys(boolean isReturnGeneratedKeys) {
        this._isReturnGeneratedKeys = isReturnGeneratedKeys;
        if (this._isReturnGeneratedKeys && this._generatedKeys != null) {
            this._generatedKeys.init();
        }
    }

    public boolean isGroupNull(int index) {
        return this._groupItem.isNull(index);
    }

    public void setGroupString(int index, String value) {
        this._groupItem.setString(index, value);
    }

    public String getGroupString(int index) {
        return this._groupItem.getString(index);
    }

    public void setGroupLong(int index, long value) {
        this._groupItem.setLong(index, value);
    }

    public long getGroupLong(int index) {
        return this._groupItem.getLong(index);
    }

    public void setGroupDouble(int index, double value) {
        this._groupItem.setDouble(index, value);
    }

    public double getGroupDouble(int index) {
        return this._groupItem.getDouble(index);
    }

    public Data getGroupData(int index) {
        return this._groupItem.getData(index);
    }

    public void setNull(int index) {
        this._parameters[index].setString(null);
    }

    public boolean isNull(int index) {
        return this._parameters[index].isNull();
    }

    public void setLong(int index, long value) {
        this._parameters[index].setLong(value);
    }

    public int getBoolean(int index) {
        return this._parameters[index].getBoolean();
    }

    public void setBoolean(int index, boolean value) {
        this._parameters[index].setBoolean(value);
    }

    public long getLong(int index) {
        return this._parameters[index].getLong();
    }

    public long getDate(int index) {
        return this._parameters[index].getDate();
    }

    public void setDouble(int index, double value) {
        this._parameters[index].setDouble(value);
    }

    public double getDouble(int index) {
        return this._parameters[index].getDouble();
    }

    public void setString(int index, String value) {
        this._parameters[index].setString(value);
    }

    public String getString(int index) {
        return this._parameters[index].getString();
    }

    public void setResult(SelectResult result) {
        this._result = result;
    }

    public SelectResult getResult() {
        return this._result;
    }

    public GeneratedKeysResultSet getGeneratedKeysResultSet() {
        if (!this._isReturnGeneratedKeys) {
            return null;
        }
        if (this._generatedKeys == null) {
            this._generatedKeys = new GeneratedKeysResultSet();
        }
        return this._generatedKeys;
    }

    public static void free(QueryContext queryContext) {
        queryContext._groupMap = null;
        _freeList.free(queryContext);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.QueryContext");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

