/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;
import java.util.logging.Logger;

class OidExpr
extends Expr {
    private static final Logger log = Log.open(OidExpr._resin_compat_class_0());
    private Table _table;
    private int _tableIndex;
    private static Class _resin_compat_class_0;

    OidExpr(Table table, int tableIndex) {
        this._table = table;
        this._tableIndex = tableIndex;
    }

    public Class getType() {
        return Long.TYPE;
    }

    public String getName() {
        return "resin_oid";
    }

    public Table getTable() {
        return this._table;
    }

    public boolean isNull(QueryContext context) throws SQLException {
        return false;
    }

    public String evalString(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return String.valueOf(row.getRowAddress());
    }

    public int evalInt(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return (int)row.getRowAddress();
    }

    public long evalLong(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getRowAddress();
    }

    public double evalDouble(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getRowAddress();
    }

    public String toString() {
        return new CharBuffer().append("OidExpr[").append(this._tableIndex).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.OidExpr");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

