/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.log.Log;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LongExpr
extends Expr {
    private static final Logger log = Log.open(LongExpr._resin_compat_class_0());
    private long _value;
    private static Class _resin_compat_class_0;

    LongExpr(long value) {
        this._value = value;
    }

    @Override
    public Class getType() {
        return Long.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return 0L;
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        return this._value;
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        return this._value;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return String.valueOf(this._value);
    }

    @Override
    public void evalToResult(QueryContext context, SelectResult result) {
        result.writeLong(this._value);
    }

    public String toString() {
        return String.valueOf(this._value);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.LongExpr");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

