/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.Database;
import com.caucho.db.sql.AutoIncrementExpr;
import com.caucho.db.sql.DefaultExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.NullExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InsertQuery
extends Query {
    private static final Logger log = Log.open(InsertQuery._resin_compat_class_0());
    private Table _table;
    private ArrayList<Column> _columns;
    private ArrayList<Expr> _values;
    private static Class _resin_compat_class_0;

    InsertQuery(Database db, String sql, Table table, ArrayList<Column> columns) throws SQLException {
        super(db, sql, null);
        this._table = table;
        this._columns = columns;
    }

    public void setValues(ArrayList<Expr> values) {
        this._values = values;
    }

    void init() throws SQLException {
        Column[] tableColumns = this._table.getColumns();
        for (int i = 0; i < tableColumns.length; ++i) {
            int j;
            Column column = tableColumns[i];
            Expr defaultExpr = column.getDefault();
            if (column.getAutoIncrement() > 0) {
                defaultExpr = new AutoIncrementExpr(column.getTable());
            }
            if (defaultExpr == null) continue;
            for (j = 0; j < this._columns.size() && this._columns.get(j) != column; ++j) {
            }
            if (j == this._columns.size()) {
                this._columns.add(column);
                this._values.add(new NullExpr());
            }
            this._values.set(j, new DefaultExpr(this._values.get(j), defaultExpr));
        }
    }

    @Override
    public void execute(QueryContext queryContext, Transaction xa) throws SQLException {
        boolean isOkay = false;
        if (xa.isAutoCommit()) {
            xa.lockAutoCommitWrite(this._table.getLock());
        } else {
            xa.lockWrite(this._table.getLock());
        }
        try {
            this._table.insert(queryContext, xa, this._columns, this._values);
            queryContext.setRowUpdateCount(1);
            isOkay = true;
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
        finally {
            if (xa.isAutoCommit()) {
                xa.commitAutoCommitWrite(this._table.getLock());
            }
        }
    }

    public String toString() {
        return "InsertQuery[]";
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.InsertQuery");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

