/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.Database;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;
import java.util.logging.Logger;

class DeleteQuery
extends Query {
    private static final Logger log = Log.open(DeleteQuery._resin_compat_class_0());
    private final Table _table;
    private static Class _resin_compat_class_0;

    DeleteQuery(Database db, String sql, Table table) throws SQLException {
        super(db, sql, null);
        this._table = table;
        this.setFromItems(new FromItem[]{new FromItem(table, table.getName())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(QueryContext context, Transaction xa) throws SQLException {
        int count = 0;
        TableIterator[] rows = new TableIterator[]{this._table.createTableIterator()};
        context.init(xa, rows);
        if (xa.isAutoCommit()) {
            xa.lockAutoCommitWrite(this._table.getLock());
        } else {
            xa.lockWrite(this._table.getLock());
        }
        try {
            if (!this.start(rows, rows.length, context, xa)) {
                return;
            }
            do {
                rows[0].delete();
                context.setRowUpdateCount(++count);
            } while (this.nextTuple(rows, rows.length, context, xa));
        }
        finally {
            this.freeRows(rows, rows.length);
            if (xa.isAutoCommit()) {
                xa.commitAutoCommitWrite(this._table.getLock());
            }
        }
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("DeleteQuery[");
        if (this._whereExpr != null) {
            cb.append(new CharBuffer().append(",where:").append(this._whereExpr).toString());
        }
        cb.append("]");
        return cb.close();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.sql.DeleteQuery");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

