/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.jdbc;

import com.caucho.db.Database;
import com.caucho.db.jdbc.ConnectionImpl;
import com.caucho.db.jdbc.GeneratedKeysResultSet;
import com.caucho.db.jdbc.NullResultSet;
import com.caucho.db.jdbc.ResultSetImpl;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectQuery;
import com.caucho.db.store.Transaction;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class StatementImpl
implements Statement {
    private static final L10N L = new L10N(StatementImpl._resin_compat_class_0());
    protected Database _db;
    protected final ConnectionImpl _conn;
    protected ResultSetImpl _rs;
    protected QueryContext _queryContext;
    private boolean _isClosed;
    private static Class _resin_compat_class_0;

    StatementImpl(ConnectionImpl conn) {
        this._conn = conn;
        this._db = conn.getDatabase();
        if (this._db == null) {
            throw new NullPointerException();
        }
        this.init();
    }

    protected void init() {
        if (this._queryContext == null) {
            this._queryContext = QueryContext.allocate();
        }
    }

    protected QueryContext getQueryContext() {
        if (this._queryContext == null) {
            this._queryContext = QueryContext.allocate();
        }
        return this._queryContext;
    }

    public void addBatch(String sql) {
    }

    public void cancel() {
    }

    public void clearBatch() {
    }

    public void clearWarnings() {
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        if (this._db == null) {
            throw new SQLException(L.l("statement is closed"));
        }
        Query query = this._db.parseQuery(sql);
        return this.executeQuery(query);
    }

    private ResultSet executeQuery(Query query) throws SQLException {
        query.execute(this._queryContext, this._conn.getTransaction());
        this._rs = new ResultSetImpl(this, this._queryContext.getResult());
        return this._rs;
    }

    public int executeUpdate(String sql) throws SQLException {
        Query query = this._db.parseQuery(sql);
        return this.executeUpdate(query);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        Query query = this._db.parseQuery(sql);
        this._queryContext.setReturnGeneratedKeys(true);
        return this.executeUpdate(query);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        Query query = this._db.parseQuery(sql);
        this._queryContext.setReturnGeneratedKeys(true);
        return this.executeUpdate(query);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        Query query = this._db.parseQuery(sql);
        this._queryContext.setReturnGeneratedKeys(true);
        return this.executeUpdate(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(Query query) throws SQLException {
        Transaction xa = this._conn.getTransaction();
        boolean isOkay = false;
        this._queryContext.setTransaction(xa);
        try {
            query.execute(this._queryContext, xa);
            isOkay = true;
        }
        finally {
            if (xa.isAutoCommit()) {
                if (isOkay) {
                    xa.commit();
                } else {
                    xa.rollback();
                }
            }
        }
        return this._queryContext.getRowUpdateCount();
    }

    public ResultSet getGeneratedKeys() {
        GeneratedKeysResultSet rs = this._queryContext.getGeneratedKeysResultSet();
        if (rs != null) {
            return rs;
        }
        return new NullResultSet();
    }

    public boolean execute(String sql) throws SQLException {
        Query query = this._db.parseQuery(sql);
        if (query instanceof SelectQuery) {
            this.executeQuery(query);
            return true;
        }
        this.executeUpdate(query);
        return false;
    }

    public int[] executeBatch() throws SQLException {
        return null;
    }

    public ResultSet getResultSet() {
        return this._rs;
    }

    public int getUpdateCount() {
        return this._queryContext.getRowUpdateCount();
    }

    public Connection getConnection() {
        return this._conn;
    }

    public int getFetchDirection() {
        return 0;
    }

    public int getFetchSize() {
        return 0;
    }

    public int getMaxFieldSize() {
        return 0;
    }

    public int getMaxRows() {
        return 0;
    }

    public void setMaxRows(int max) {
    }

    public boolean getMoreResults() {
        return false;
    }

    public int getQueryTimeout() {
        return 0;
    }

    public int getResultSetConcurrency() {
        return 0;
    }

    public int getResultSetType() {
        return 0;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void setCursorName(String name) {
    }

    public void setEscapeProcessing(boolean enable) {
    }

    public void setFetchDirection(int direction) {
    }

    public void setFetchSize(int rows) {
    }

    public void setMaxFieldSize(int max) {
    }

    public void setQueryTimeout(int seconds) {
    }

    public boolean getMoreResults(int count) {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String query, int foo) {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String query, int[] foo) {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String query, String[] foo) {
        throw new UnsupportedOperationException();
    }

    public int getResultSetHoldability() {
        throw new UnsupportedOperationException();
    }

    public void close() throws SQLException {
        this._db = null;
        ResultSetImpl rs = this._rs;
        this._rs = null;
        QueryContext queryContext = this._queryContext;
        this._queryContext = null;
        if (rs != null) {
            rs.close();
        }
        this._conn.closeStatement(this);
        if (queryContext != null) {
            QueryContext.free(queryContext);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.jdbc.StatementImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

