/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.jdbc;

import com.caucho.db.jdbc.ConnectionImpl;
import com.caucho.db.jdbc.ResultSetImpl;
import com.caucho.db.jdbc.StatementImpl;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.store.Transaction;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class PreparedStatementImpl
extends StatementImpl
implements PreparedStatement {
    private Query _query;
    private int _updateCount;
    private boolean _wasResultSet;
    private ResultSet _resultSet;
    private boolean _isReturnGeneratedKeys;

    PreparedStatementImpl(ConnectionImpl conn, Query query) {
        super(conn);
        this._query = query;
    }

    void setReturnGeneratedKeys(boolean isReturnGeneratedKeys) {
        this._isReturnGeneratedKeys = isReturnGeneratedKeys;
    }

    public ResultSetMetaData getMetaData() {
        return null;
    }

    public void clearParameters() throws SQLException {
        this._query.clearParameters();
    }

    public void setNull(int parameter, int sqlType) throws SQLException {
        this._query.setString(parameter, null);
    }

    public void setNull(int parameter, int sqlType, String typeName) throws SQLException {
        this._query.setString(parameter, null);
    }

    public void setBoolean(int parameter, boolean x) throws SQLException {
        this._query.setBoolean(parameter, x);
    }

    public void setByte(int parameter, byte x) throws SQLException {
        this._query.setLong(parameter, x);
    }

    public void setShort(int parameter, short x) throws SQLException {
        this._query.setLong(parameter, x);
    }

    public void setInt(int parameter, int x) throws SQLException {
        this._query.setLong(parameter, x);
    }

    public void setLong(int parameter, long x) throws SQLException {
        this._query.setLong(parameter, x);
    }

    public void setFloat(int parameter, float x) throws SQLException {
        this._query.setDouble(parameter, x);
    }

    public void setDouble(int parameter, double x) throws SQLException {
        this._query.setDouble(parameter, x);
    }

    public void setBigDecimal(int parameter, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setString(int parameter, String x) throws SQLException {
        this._query.setString(parameter, x);
    }

    public void setBytes(int parameter, byte[] x) throws SQLException {
        if (x != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(x);
            this._query.setBinaryStream(parameter, bis, x.length);
        } else {
            this.setNull(parameter, 0);
        }
    }

    public void setDate(int parameter, Date x, Calendar calendar) throws SQLException {
        this.setDate(parameter, x);
    }

    public void setDate(int parameter, Date x) throws SQLException {
        if (x != null) {
            this.setTime(parameter, x.getTime());
        } else {
            this.setNull(parameter, 0);
        }
    }

    public void setTime(int parameter, Time x, Calendar calendar) throws SQLException {
        this.setTime(parameter, x);
    }

    public void setTime(int parameter, Time x) throws SQLException {
        if (x != null) {
            this.setTime(parameter, x.getTime());
        } else {
            this.setNull(parameter, 0);
        }
    }

    public void setTimestamp(int parameter, Timestamp x, Calendar calendar) throws SQLException {
        this.setTimestamp(parameter, x);
    }

    public void setTimestamp(int parameter, Timestamp x) throws SQLException {
        if (x != null) {
            this.setTime(parameter, x.getTime());
        } else {
            this.setNull(parameter, 0);
        }
    }

    private void setTime(int parameter, long now) throws SQLException {
        this._query.setDate(parameter, now);
    }

    public void setAsciiStream(int parameter, InputStream is, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setUnicodeStream(int parameter, InputStream is, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBinaryStream(int parameter, InputStream is, int len) throws SQLException {
        this._query.setBinaryStream(parameter, is, len);
    }

    public void setCharacterStream(int parameter, Reader is, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setObject(int parameter, Object x, int target, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setObject(int parameter, Object x, int target) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setObject(int parameter, Object x) throws SQLException {
        if (x instanceof String) {
            this.setString(parameter, (String)x);
        } else if (x instanceof Number) {
            Number number = (Number)x;
            if (x instanceof Double) {
                this.setDouble(parameter, number.doubleValue());
            } else if (x instanceof Float) {
                this.setDouble(parameter, number.doubleValue());
            } else {
                this.setLong(parameter, number.longValue());
            }
        } else if (x instanceof Time) {
            this.setTime(parameter, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameter, (Timestamp)x);
        } else if (x instanceof Date) {
            this.setDate(parameter, (Date)x);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setRef(int parameter, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBlob(int parameter, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setClob(int parameter, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setArray(int parameter, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void addBatch() throws SQLException {
    }

    public ResultSet executeQuery() throws SQLException {
        this.execute();
        if (this._wasResultSet) {
            return this._resultSet;
        }
        throw new SQLException("missing result set");
    }

    public int executeUpdate() throws SQLException {
        this.execute();
        return this.getUpdateCount();
    }

    public boolean execute() throws SQLException {
        Transaction xa = this._conn.getTransaction();
        QueryContext queryContext = this.getQueryContext();
        if (this._query.isSelect()) {
            Object rs = null;
            this._query.execute(queryContext, xa);
            this._wasResultSet = true;
            this._resultSet = new ResultSetImpl(this, queryContext.getResult());
            return true;
        }
        queryContext.setReturnGeneratedKeys(this._isReturnGeneratedKeys);
        this._query.execute(queryContext, xa);
        this._wasResultSet = false;
        return false;
    }

    public void setURL(int foo, URL url) {
        throw new UnsupportedOperationException();
    }

    public ParameterMetaData getParameterMetaData() {
        throw new UnsupportedOperationException();
    }
}

