/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.jdbc;

import com.caucho.db.Database;
import com.caucho.db.jdbc.ConnectionImpl;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DataSourceImpl
implements DataSource {
    private static final Logger log = Log.open(DataSourceImpl._resin_compat_class_0());
    private static final L10N L = new L10N(DataSourceImpl._resin_compat_class_0());
    private Database _database = new Database();
    private boolean _createDatabase;
    private boolean _isInit;
    private static Class _resin_compat_class_0;

    public DataSourceImpl() {
    }

    public DataSourceImpl(Path path) throws SQLException {
        this();
        this.setPath(path);
        this.init();
    }

    public void setPath(Path path) {
        this._database.setPath(path);
    }

    public void setCreateDatabase(boolean create) {
        this._createDatabase = create;
    }

    public void setRemoveOnError(boolean remove) {
        this._database.setRemoveOnError(remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws SQLException {
        DataSourceImpl dataSourceImpl = this;
        synchronized (dataSourceImpl) {
            if (this._isInit) {
                return;
            }
            try {
                this._database.init();
            }
            finally {
                this._isInit = true;
            }
        }
    }

    public int getLoginTimeout() {
        return 0;
    }

    public void setLoginTimeout(int foo) {
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    public void setLogWriter(PrintWriter log) {
    }

    public Connection getConnection(String user, String password) throws SQLException {
        return this.getConnection();
    }

    public Connection getConnection() throws SQLException {
        this.init();
        return new ConnectionImpl(this._database);
    }

    public void close() {
        this._database.close();
    }

    public String toString() {
        return new CharBuffer().append("DataSourceImpl[").append(this._database.getPath()).append("]").toString();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this._database.close();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.jdbc.DataSourceImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

