/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.index;

import com.caucho.db.Database;
import com.caucho.db.index.KeyCompare;
import com.caucho.db.index.StringKeyCompare;
import com.caucho.db.store.Block;
import com.caucho.db.store.BlockManager;
import com.caucho.db.store.Store;
import com.caucho.db.store.Transaction;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTree {
    private static final L10N L = new L10N(BTree._resin_compat_class_0());
    private static final Logger log = Log.open(BTree._resin_compat_class_0());
    public static final long FAIL = Long.MIN_VALUE;
    private static final int BLOCK_SIZE = 65536;
    private static final int PTR_SIZE = 8;
    private static final int FLAGS_OFFSET = 0;
    private static final int LENGTH_OFFSET = 4;
    private static final int PARENT_OFFSET = 8;
    private static final int NEXT_OFFSET = 16;
    private static final int HEADER_SIZE = 24;
    private static final int LEAF_FLAG = 1;
    private BlockManager _blockManager;
    private Store _store;
    private long _indexRoot;
    private int _keySize;
    private int _tupleSize;
    private int _n;
    private int _minN;
    private KeyCompare _keyCompare;
    private int _blockCount;
    private volatile boolean _isStarted;
    private static Class _resin_compat_class_0;

    public BTree(Store store, long indexRoot, int keySize, KeyCompare keyCompare) throws IOException {
        if (keyCompare == null) {
            throw new NullPointerException();
        }
        this._store = store;
        this._blockManager = this._store.getBlockManager();
        this._indexRoot = indexRoot;
        if (65536 < keySize + 24) {
            throw new IOException(L.l("BTree key size `{0}' is too large.", keySize));
        }
        this._keySize = keySize;
        this._tupleSize = keySize + 16 - 1;
        this._tupleSize -= this._tupleSize % 8;
        this._n = 65512 / this._tupleSize;
        this._minN = (this._n + 1) / 2;
        if (this._minN < 0) {
            this._minN = 1;
        }
        this._keyCompare = keyCompare;
    }

    public long getIndexRoot() {
        return this._indexRoot;
    }

    public void create() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long lookup(byte[] keyBuffer, int keyOffset, int keyLength, Transaction xa) throws IOException {
        long index = this._indexRoot;
        while (index != 0L) {
            Block block = this._store.readBlockByAddress(index);
            boolean isLeaf = true;
            try {
                byte[] buffer = block.getBuffer();
                int flags = this.getInt(buffer, 0);
                isLeaf = (flags & 1) == 0;
                index = this.lookupTuple(block.getBlockId(), buffer, keyBuffer, keyOffset, keyLength, isLeaf);
            }
            finally {
                block.free();
            }
            if (!isLeaf && index != Long.MIN_VALUE) continue;
            return index;
        }
        return Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void insert(byte[] keyBuffer, int keyOffset, int keyLength, long value, Transaction xa) throws SQLException {
        try {
            if (value == Long.MIN_VALUE) {
                throw new IllegalArgumentException();
            }
            long index = this._indexRoot;
            long parentIndex = 0L;
            while (index != Long.MIN_VALUE) {
                long lastIndex = index;
                Block block = this._store.readBlockByAddress(index);
                try {
                    byte[] buffer = block.getBuffer();
                    int flags = this.getInt(buffer, 0);
                    boolean isLeaf = (flags & 1) == 0;
                    int length = this.getInt(buffer, 4);
                    if (length == this._n) {
                        if (index == this._indexRoot) {
                            this.split(index, xa);
                            continue;
                        }
                        if (parentIndex != 0L) {
                            this.split(parentIndex, index, xa);
                            index = parentIndex;
                            parentIndex = 0L;
                            continue;
                        }
                    }
                    if (!isLeaf) {
                        parentIndex = index;
                        index = this.lookupTuple(block.getBlockId(), buffer, keyBuffer, keyOffset, keyLength, isLeaf);
                        continue;
                    }
                    block.setFlushDirtyOnCommit(false);
                    block.setDirty(0, 65536);
                    this.insertLeafBlock(index, block.getBuffer(), keyBuffer, keyOffset, keyLength, value);
                    return;
                }
                finally {
                    block.free();
                }
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    private long insertLeafBlock(long blockIndex, byte[] block, byte[] keyBuffer, int keyOffset, int keyLength, long value) throws IOException {
        int offset = 24;
        int tupleSize = this._tupleSize;
        int length = this.getInt(block, 4);
        for (int i = 0; i < length; ++i) {
            int cmp = this._keyCompare.compare(keyBuffer, keyOffset, block, offset + 8, keyLength);
            if (0 < cmp) {
                offset += tupleSize;
                continue;
            }
            if (cmp == 0) {
                this.setPointer(block, offset, value);
                return 0L;
            }
            if (length < this._n) {
                return this.addKey(blockIndex, block, offset, i, length, keyBuffer, keyOffset, keyLength, value);
            }
            throw new IllegalStateException("ran out of key space");
        }
        if (length < this._n) {
            return this.addKey(blockIndex, block, offset, length, length, keyBuffer, keyOffset, keyLength, value);
        }
        throw new IllegalStateException();
    }

    private long addKey(long blockIndex, byte[] block, int offset, int index, int length, byte[] keyBuffer, int keyOffset, int keyLength, long value) throws IOException {
        int tupleSize = this._tupleSize;
        if (index < length) {
            System.arraycopy(block, offset, block, offset + tupleSize, (length - index) * tupleSize);
        }
        this.setPointer(block, offset, value);
        this.setLength(block, length + 1);
        if (log.isLoggable(Level.FINER)) {
            log.finer(new CharBuffer().append("btree insert at ").append(blockIndex / 65536L).append(":").append(offset).append(" value:").append(value / 65536L).append(":").append(value % 65536L).toString());
        }
        System.arraycopy(keyBuffer, keyOffset, block, offset + 8, keyLength);
        for (int j = tupleSize - 8 - keyLength; j >= 0; --j) {
            block[offset + tupleSize - j] = 0;
        }
        return -value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void split(long parentIndex, long index, Transaction xa) throws IOException {
        log.finer(new CharBuffer().append("btree splitting ").append(index / 65536L).toString());
        Block parentBlock = null;
        Block leftBlock = null;
        Block rightBlock = null;
        try {
            parentBlock = this._store.readBlockByAddress(parentIndex);
            parentBlock.setDirty(0, 65536);
            byte[] parentBuffer = parentBlock.getBuffer();
            int parentLength = this.getInt(parentBuffer, 4);
            rightBlock = this._store.readBlockByAddress(index);
            rightBlock.setDirty(0, 65536);
            byte[] rightBuffer = rightBlock.getBuffer();
            long rightBlockId = rightBlock.getBlockId();
            leftBlock = this._store.allocateIndexBlock();
            leftBlock.setDirty(0, 65536);
            byte[] leftBuffer = leftBlock.getBuffer();
            long leftBlockId = leftBlock.getBlockId();
            int length = this.getInt(rightBuffer, 4);
            int pivot = (length - 1) / 2;
            int pivotOffset = 24 + pivot * this._tupleSize;
            System.arraycopy(rightBuffer, 24, leftBuffer, 24, pivotOffset + this._tupleSize - 24);
            this.setInt(leftBuffer, 0, this.getInt(rightBuffer, 0));
            this.setLength(leftBuffer, pivot + 1);
            this.setPointer(leftBuffer, 16, rightBlockId);
            this.setPointer(leftBuffer, 8, parentIndex);
            System.arraycopy(rightBuffer, pivotOffset + this._tupleSize, rightBuffer, 24, (length - pivot - 1) * this._tupleSize);
            this.setLength(rightBuffer, length - pivot - 1);
            this.insertLeafBlock(parentIndex, parentBuffer, leftBuffer, pivotOffset + 8, this._keySize, leftBlockId);
        }
        finally {
            if (parentBlock != null) {
                parentBlock.free();
            }
            if (leftBlock != null) {
                leftBlock.free();
            }
            if (rightBlock != null) {
                rightBlock.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long split(long index, Transaction xa) throws IOException {
        log.finer(new CharBuffer().append("btree splitting ").append(index / 65536L).toString());
        Block parentBlock = null;
        Block leftBlock = null;
        Block rightBlock = null;
        try {
            parentBlock = this._store.readBlockByAddress(index);
            parentBlock.setDirty(0, 65536);
            byte[] parentBuffer = parentBlock.getBuffer();
            int parentFlags = this.getInt(parentBuffer, 0);
            leftBlock = this._store.allocateIndexBlock();
            leftBlock.setDirty(0, 65536);
            long leftBlockId = leftBlock.getBlockId();
            rightBlock = this._store.allocateIndexBlock();
            rightBlock.setDirty(0, 65536);
            long rightBlockId = rightBlock.getBlockId();
            int length = this.getInt(parentBuffer, 4);
            int pivot = (length - 1) / 2;
            int pivotOffset = 24 + pivot * this._tupleSize;
            long pivotValue = this.getPointer(parentBuffer, pivotOffset);
            byte[] leftBuffer = leftBlock.getBuffer();
            System.arraycopy(parentBuffer, 24, leftBuffer, 24, pivotOffset + this._tupleSize - 24);
            this.setInt(leftBuffer, 0, parentFlags);
            this.setLength(leftBuffer, pivot + 1);
            this.setPointer(leftBuffer, 8, index);
            this.setPointer(leftBuffer, 16, rightBlockId);
            byte[] rightBuffer = rightBlock.getBuffer();
            System.arraycopy(parentBuffer, pivotOffset + this._tupleSize, rightBuffer, 24, (length - pivot - 1) * this._tupleSize);
            this.setInt(rightBuffer, 0, parentFlags);
            this.setLength(rightBuffer, length - pivot - 1);
            this.setPointer(rightBuffer, 8, index);
            this.setPointer(rightBuffer, 16, this.getPointer(parentBuffer, 16));
            System.arraycopy(parentBuffer, pivotOffset, parentBuffer, 24, this._tupleSize);
            this.setPointer(parentBuffer, 24, leftBlockId);
            this.setInt(parentBuffer, 0, 1);
            this.setLength(parentBuffer, 1);
            this.setPointer(parentBuffer, 16, rightBlockId);
            long l = index;
            return l;
        }
        finally {
            if (parentBlock != null) {
                parentBlock.free();
            }
            if (leftBlock != null) {
                leftBlock.free();
            }
            if (rightBlock != null) {
                rightBlock.free();
            }
        }
    }

    public synchronized void remove(byte[] keyBuffer, int keyOffset, int keyLength, Transaction xa) throws SQLException {
        try {
            this.remove(-1L, this._indexRoot, keyBuffer, keyOffset, keyLength, xa);
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(long parentIndex, long index, byte[] keyBuffer, int keyOffset, int keyLength, Transaction xa) throws IOException {
        Block block = this._store.readBlockByAddress(index);
        try {
            boolean isLeaf;
            byte[] buffer = block.getBuffer();
            int flags = this.getInt(buffer, 0);
            boolean bl = isLeaf = (flags & 1) == 0;
            if (isLeaf) {
                block.setDirty(0, 65536);
                this.removeLeafBlock(index, block.getBuffer(), keyBuffer, keyOffset, keyLength);
            } else {
                long childIndex = this.lookupTuple(block.getBlockId(), buffer, keyBuffer, keyOffset, keyLength, false);
                if (childIndex == Long.MIN_VALUE) {
                    return;
                }
                this.remove(block.getBlockId(), childIndex, keyBuffer, keyOffset, keyLength, xa);
            }
            if (this.joinBlocks(parentIndex, buffer, index, xa)) {
                xa.deallocateBlock(block);
            }
        }
        finally {
            block.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean joinBlocks(long parentIndex, byte[] buffer, long index, Transaction xa) throws IOException {
        Block parent;
        block30: {
            Block rightBlock2;
            Block leftBlock;
            if (parentIndex <= 0L) {
                return false;
            }
            int length = this.getInt(buffer, 4);
            if (this._minN <= length) {
                return false;
            }
            parent = this._store.readBlockByAddress(parentIndex);
            byte[] parentBuffer = parent.getBuffer();
            int parentLength = this.getInt(parentBuffer, 4);
            long leftIndex = this.getLeftIndex(parent, index);
            long rightIndex = this.getRightIndex(parent, index);
            if (leftIndex >= 0L) {
                leftBlock = this._store.readBlockByAddress(leftIndex);
                try {
                    byte[] leftBuffer = leftBlock.getBuffer();
                    int leftLength = this.getInt(leftBuffer, 4);
                    if (this._minN < leftLength) {
                        parent.setDirty(0, 65536);
                        leftBlock.setDirty(0, 65536);
                        this.moveFromLeft(parent.getBuffer(), leftBlock.getBuffer(), buffer, index);
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    leftBlock.free();
                }
            }
            if (rightIndex >= 0L) {
                rightBlock2 = this._store.readBlockByAddress(rightIndex);
                try {
                    byte[] rightBuffer = rightBlock2.getBuffer();
                    int rightLength = this.getInt(rightBuffer, 4);
                    if (this._minN < rightLength) {
                        parent.setDirty(0, 65536);
                        rightBlock2.setDirty(0, 65536);
                        this.moveFromRight(parent.getBuffer(), rightBlock2.getBuffer(), buffer, index);
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    rightBlock2.free();
                }
            }
            if (parentLength < 2) {
                boolean rightBlock2 = false;
                return rightBlock2;
            }
            if (leftIndex >= 0L) {
                leftBlock = this._store.readBlockByAddress(leftIndex);
                try {
                    parent.setDirty(0, 65536);
                    leftBlock.setDirty(0, 65536);
                    this.mergeLeft(parent.getBuffer(), leftBlock.getBuffer(), buffer, index);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    leftBlock.free();
                }
            }
            if (rightIndex < 0L) break block30;
            rightBlock2 = this._store.readBlockByAddress(rightIndex);
            try {
                rightBlock2.setDirty(0, 65536);
                parent.setDirty(0, 65536);
                this.mergeRight(parent.getBuffer(), rightBlock2.getBuffer(), buffer, index);
                boolean bl = true;
                return bl;
            }
            finally {
                rightBlock2.free();
            }
        }
        boolean bl = false;
        return bl;
        finally {
            parent.free();
        }
    }

    private long getLeftIndex(Block block, long index) {
        long pointer;
        int offset;
        byte[] buffer = block.getBuffer();
        int length = this.getInt(buffer, 4);
        int tupleSize = this._tupleSize;
        int end = offset + length * tupleSize;
        for (offset = 24; offset < end; offset += tupleSize) {
            pointer = this.getPointer(buffer, offset);
            if (pointer != index) continue;
            if (24 < offset) {
                return this.getPointer(buffer, offset - tupleSize);
            }
            return -1L;
        }
        pointer = this.getPointer(buffer, 16);
        if (pointer == index) {
            return this.getPointer(buffer, 24 + (length - 1) * tupleSize);
        }
        return -1L;
    }

    private void moveFromLeft(byte[] parentBuffer, byte[] leftBuffer, byte[] buffer, long index) {
        int parentLength = this.getInt(parentBuffer, 4);
        int tupleSize = this._tupleSize;
        int parentOffset = 24;
        int parentEnd = parentOffset + parentLength * tupleSize;
        int leftLength = this.getInt(leftBuffer, 4);
        int length = this.getInt(buffer, 4);
        int parentLeftOffset = -1;
        if (index == this.getPointer(parentBuffer, 16)) {
            parentLeftOffset = parentEnd - tupleSize;
        } else {
            parentOffset += tupleSize;
            while (parentOffset < parentEnd) {
                long pointer = this.getPointer(parentBuffer, parentOffset);
                if (pointer == index) {
                    parentLeftOffset = parentOffset - tupleSize;
                    break;
                }
                parentOffset += tupleSize;
            }
        }
        if (parentLeftOffset < 0) {
            log.warning("Can't find parent left in deletion borrow left ");
            return;
        }
        System.arraycopy(buffer, 24, buffer, 24 + tupleSize, length * tupleSize);
        System.arraycopy(leftBuffer, 24 + (leftLength - 1) * tupleSize, buffer, 24, tupleSize);
        this.setInt(buffer, 4, length + 1);
        this.setInt(leftBuffer, 4, --leftLength);
        System.arraycopy(leftBuffer, 24 + (leftLength - 1) * tupleSize + 8, parentBuffer, parentLeftOffset + 8, tupleSize - 8);
    }

    private void mergeLeft(byte[] parentBuffer, byte[] leftBuffer, byte[] buffer, long index) {
        long pointer;
        int parentLength = this.getInt(parentBuffer, 4);
        int tupleSize = this._tupleSize;
        int parentOffset = 24;
        int parentEnd = parentOffset + parentLength * tupleSize;
        int leftLength = this.getInt(leftBuffer, 4);
        int length = this.getInt(buffer, 4);
        parentOffset += tupleSize;
        while (parentOffset < parentEnd) {
            pointer = this.getPointer(parentBuffer, parentOffset);
            if (pointer == index) {
                int leftOffset = 24 + leftLength * tupleSize;
                this.setPointer(parentBuffer, parentOffset, this.getPointer(parentBuffer, parentOffset - tupleSize));
                System.arraycopy(parentBuffer, parentOffset, parentBuffer, parentOffset - tupleSize, parentEnd - parentOffset);
                this.setInt(parentBuffer, 4, parentLength - 1);
                this.setPointer(leftBuffer, leftOffset, this.getPointer(leftBuffer, 16));
                this.setPointer(leftBuffer, 16, this.getPointer(buffer, 16));
                System.arraycopy(buffer, 24, leftBuffer, leftOffset, length * tupleSize);
                this.setInt(leftBuffer, 4, leftLength + length);
                return;
            }
            parentOffset += tupleSize;
        }
        pointer = this.getPointer(parentBuffer, 16);
        if (pointer != index) {
            log.warning(new CharBuffer().append("BTree remove can't find matching index: ").append(index).toString());
            return;
        }
        int leftOffset = 24 + (parentLength - 1) * tupleSize;
        long leftPointer = this.getPointer(parentBuffer, leftOffset);
        this.setPointer(parentBuffer, 16, leftPointer);
        this.setInt(parentBuffer, 4, parentLength - 1);
        this.setPointer(leftBuffer, 16, this.getPointer(buffer, 16));
        System.arraycopy(buffer, 24, leftBuffer, 24 + leftLength * tupleSize, length * tupleSize);
        this.setInt(leftBuffer, 4, leftLength + length);
    }

    private long getRightIndex(Block block, long index) {
        int offset;
        byte[] buffer = block.getBuffer();
        int length = this.getInt(buffer, 4);
        int tupleSize = this._tupleSize;
        int end = offset + length * tupleSize;
        for (offset = 24; offset < end; offset += tupleSize) {
            long pointer = this.getPointer(buffer, offset);
            if (pointer != index) continue;
            if (offset + tupleSize < end) {
                return this.getPointer(buffer, offset + tupleSize);
            }
            return this.getPointer(buffer, 16);
        }
        return -1L;
    }

    private void moveFromRight(byte[] parentBuffer, byte[] rightBuffer, byte[] buffer, long index) {
        long pointer;
        int parentOffset;
        int parentLength = this.getInt(parentBuffer, 4);
        int tupleSize = this._tupleSize;
        int parentEnd = parentOffset + parentLength * tupleSize;
        int rightLength = this.getInt(rightBuffer, 4);
        int length = this.getInt(buffer, 4);
        for (parentOffset = 24; parentOffset < parentEnd && (pointer = this.getPointer(parentBuffer, parentOffset)) != index; parentOffset += tupleSize) {
        }
        if (parentEnd <= parentOffset) {
            log.warning("Can't find buffer in deletion borrow right ");
            return;
        }
        System.arraycopy(rightBuffer, 24, buffer, 24 + length * tupleSize, tupleSize);
        System.arraycopy(rightBuffer, 24 + tupleSize, rightBuffer, 24, (rightLength - 1) * tupleSize);
        this.setInt(buffer, 4, length + 1);
        this.setInt(rightBuffer, 4, rightLength - 1);
        System.arraycopy(buffer, 24 + length * tupleSize + 8, parentBuffer, parentOffset + 8, tupleSize - 8);
    }

    private void mergeRight(byte[] parentBuffer, byte[] rightBuffer, byte[] buffer, long index) {
        int parentOffset;
        int parentLength = this.getInt(parentBuffer, 4);
        int tupleSize = this._tupleSize;
        int parentEnd = parentOffset + parentLength * tupleSize;
        int rightLength = this.getInt(rightBuffer, 4);
        int length = this.getInt(buffer, 4);
        for (parentOffset = 24; parentOffset < parentEnd; parentOffset += tupleSize) {
            long pointer = this.getPointer(parentBuffer, parentOffset);
            if (pointer != index) continue;
            System.arraycopy(rightBuffer, 24, rightBuffer, 24 + length * tupleSize, rightLength * tupleSize);
            System.arraycopy(buffer, 24, rightBuffer, 24, length * tupleSize);
            this.setInt(rightBuffer, 4, length + rightLength);
            System.arraycopy(parentBuffer, parentOffset + tupleSize, parentBuffer, parentOffset, parentEnd - parentOffset - tupleSize);
            this.setInt(parentBuffer, 4, parentLength - 1);
            return;
        }
        log.warning(new CharBuffer().append("BTree merge right can't find matching index: ").append(index).toString());
    }

    private long lookupTuple(long blockId, byte[] block, byte[] keyBuffer, int keyOffset, int keyLength, boolean isLeaf) throws IOException {
        int length = this.getInt(block, 4);
        int offset = 24;
        int tupleSize = this._tupleSize;
        int end = offset + length * tupleSize;
        while (length > 0) {
            int cmp;
            int tail = offset + tupleSize * length;
            int delta = tupleSize * (length / 2);
            int newOffset = offset + delta;
            if (newOffset > 65536) {
                Thread.dumpStack();
                System.out.println(new CharBuffer().append("OVERFLOW: ").append(blockId / 65536L).append(":").append(blockId % 65536L).append(" LENGTH:").append(length).append(" STU:").append(this.getInt(block, 4)).append(" DELTA:").append(delta).toString());
            }
            if ((cmp = this._keyCompare.compare(keyBuffer, keyOffset, block, 8 + newOffset, keyLength)) == 0) {
                return this.getPointer(block, newOffset);
            }
            if (cmp > 0) {
                offset = newOffset + tupleSize;
                length = (tail - offset) / tupleSize;
            } else if (cmp < 0) {
                length /= 2;
            }
            if (length > 0) continue;
            if (isLeaf) {
                return 0L;
            }
            if (cmp < 0) {
                return this.getPointer(block, newOffset);
            }
            if (offset == end) {
                return this.getPointer(block, 16);
            }
            return this.getPointer(block, offset);
        }
        if (isLeaf) {
            return 0L;
        }
        return this.getPointer(block, 16);
    }

    private long removeLeafBlock(long blockIndex, byte[] block, byte[] keyBuffer, int keyOffset, int keyLength) throws IOException {
        int offset = 24;
        int tupleSize = this._tupleSize;
        int length = this.getInt(block, 4);
        for (int i = 0; i < length; ++i) {
            int cmp = this._keyCompare.compare(keyBuffer, keyOffset, block, offset + 8, keyLength);
            if (0 < cmp) {
                offset += tupleSize;
                continue;
            }
            if (cmp == 0) {
                int tupleLength = length * tupleSize;
                if (offset + tupleSize < 24 + tupleLength) {
                    System.arraycopy(block, offset + tupleSize, block, offset, 24 + tupleLength - offset - tupleSize);
                }
                this.setLength(block, length - 1);
                return i;
            }
            return 0L;
        }
        return 0L;
    }

    private int getInt(byte[] buffer, int offset) {
        return ((buffer[offset + 0] & 0xFF) << 24) + ((buffer[offset + 1] & 0xFF) << 16) + ((buffer[offset + 2] & 0xFF) << 8) + (buffer[offset + 3] & 0xFF);
    }

    private long getPointer(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
    }

    private void setInt(byte[] buffer, int offset, int value) {
        buffer[offset + 0] = (byte)(value >> 24);
        buffer[offset + 1] = (byte)(value >> 16);
        buffer[offset + 2] = (byte)(value >> 8);
        buffer[offset + 3] = (byte)value;
    }

    private void setLength(byte[] buffer, int value) {
        if (value < 0 || value > 65536) {
            System.out.println(new CharBuffer().append("BAD-LENGTH: ").append(value).toString());
        }
        this.setInt(buffer, 4, value);
    }

    private void setPointer(byte[] buffer, int offset, long value) {
        if (offset <= 4) {
            System.out.println(new CharBuffer().append("BAD_POINTER: ").append(offset).toString());
        }
        buffer[offset + 0] = (byte)(value >> 56);
        buffer[offset + 1] = (byte)(value >> 48);
        buffer[offset + 2] = (byte)(value >> 40);
        buffer[offset + 3] = (byte)(value >> 32);
        buffer[offset + 4] = (byte)(value >> 24);
        buffer[offset + 5] = (byte)(value >> 16);
        buffer[offset + 6] = (byte)(value >> 8);
        buffer[offset + 7] = (byte)value;
    }

    private synchronized void start() throws IOException {
        if (this._isStarted) {
            return;
        }
        this._isStarted = true;
    }

    public ArrayList<String> getBlockKeys(long blockIndex) throws IOException {
        long blockId = this._store.addressToBlockId(blockIndex * 65536L);
        if (this._store.getAllocation(blockIndex) != 4) {
            return null;
        }
        Block block = this._store.readBlockByAddress(blockId);
        block.read();
        byte[] buffer = block.getBuffer();
        int length = this.getInt(buffer, 4);
        int offset = 24;
        int tupleSize = this._tupleSize;
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            keys.add(this._keyCompare.toString(buffer, offset + i * tupleSize + 8, tupleSize - 8));
        }
        block.free();
        return keys;
    }

    public static BTree createTest(Path path, int keySize) throws IOException, SQLException {
        Database db = new Database();
        db.setPath(path);
        db.init();
        Store store = new Store(db, "test", null);
        store.create();
        Block block = store.allocateIndexBlock();
        long blockId = block.getBlockId();
        block.free();
        return new BTree(store, blockId, keySize, new KeyCompare());
    }

    public static BTree createStringTest(Path path, int keySize) throws IOException, SQLException {
        Store store = Store.create(path);
        Block block = store.allocateIndexBlock();
        long blockId = block.getBlockId();
        block.free();
        return new BTree(store, blockId, keySize, new StringKeyCompare());
    }

    public String toString() {
        return new CharBuffer().append("BTree[").append(this._store).append(",").append(this._indexRoot / 65536L).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.index.BTree");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

