/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db;

import com.caucho.db.sql.Parser;
import com.caucho.db.sql.Query;
import com.caucho.db.store.BlockManager;
import com.caucho.db.store.Lock;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableFactory;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.CloseListener;
import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Database {
    private static final Logger log = Log.open(Database._resin_compat_class_0());
    private static final L10N L = new L10N(Database._resin_compat_class_0());
    private Path _dir;
    private BlockManager _blockManager;
    private HashMap<String, Table> _tables = new HashMap();
    private LruCache<String, Query> _cachedQueries = new LruCache(128);
    private Lock _databaseLock = new Lock(0L);
    private boolean _removeOnError;
    private long _timeout = 1000L;
    private final Lifecycle _lifecycle = new Lifecycle(log, null, Level.FINER);
    private static Class _resin_compat_class_0;

    public Database() {
        this(null);
    }

    public Database(Path dir) {
        long memorySize;
        long minSize;
        Environment.addClassLoaderListener(new CloseListener(this));
        this._lifecycle.setName(this.toString());
        if (dir != null) {
            this.setPath(dir);
        }
        if ((minSize = 0x800000L) < (memorySize = Runtime.getRuntime().maxMemory() / 8L)) {
            minSize = memorySize;
        }
        this._blockManager = BlockManager.create((int)(minSize / 65536L));
    }

    public void setPath(Path dir) {
        this._dir = dir;
    }

    public void setRemoveOnError(boolean remove) {
        this._removeOnError = remove;
    }

    public void ensureMemoryCapacity(long minCapacity) {
        int minBlocks = (int)((minCapacity + 65536L - 1L) / 65536L);
        this._blockManager.ensureCapacity(minBlocks);
    }

    public void init() throws SQLException {
        if (!this._lifecycle.toActive()) {
            return;
        }
        Path dir = this._dir;
        if (dir != null) {
            String[] list = null;
            try {
                list = dir.list();
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            for (int i = 0; i < list.length; ++i) {
                String name = list[i];
                if (!name.endsWith(".db")) continue;
                name = name.substring(0, name.length() - 3);
                try {
                    Table table = Table.loadFromFile(this, name);
                    table.init();
                    this._tables.put(name, table);
                    continue;
                }
                catch (Throwable e) {
                    if (this._removeOnError) {
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, e.toString(), e);
                        } else {
                            log.warning(e.toString());
                        }
                        try {
                            dir.lookup(new CharBuffer().append(name).append(".db").toString()).remove();
                        }
                        catch (IOException e1) {}
                        continue;
                    }
                    throw new SQLExceptionWrapper(e);
                }
            }
        }
    }

    public Path getPath() {
        return this._dir;
    }

    public BlockManager getBlockManager() {
        return this._blockManager;
    }

    public Lock getDatabaseLock() {
        return this._databaseLock;
    }

    public TableFactory createTableFactory() {
        return new TableFactory(this);
    }

    public void addTable(Table table) throws IOException {
        log.fine(new CharBuffer().append("adding table ").append(table.getName()).toString());
        table.init();
        this._tables.put(table.getName(), table);
    }

    public Table getTable(String name) {
        return this._tables.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(String name) throws SQLException {
        Table table = null;
        Database database = this;
        synchronized (database) {
            table = this._tables.get(name);
            if (table == null) {
                throw new SQLException(L.l("Table {0} does not exist.  DROP TABLE can only drop an existing table.", name));
            }
            this._tables.remove(name);
            this._cachedQueries.clear();
        }
        table.remove();
    }

    public Query parseQuery(String sql) throws SQLException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(new CharBuffer().append(this).append(": ").append(sql).toString());
        }
        Query query = Parser.parse(this, sql);
        return query;
    }

    public void close() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        Iterator<Table> i$ = this._tables.values().iterator();
        while (i$.hasNext()) {
            Table table = i$.next();
            try {
                table.close();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public String toString() {
        return new CharBuffer().append("Database[").append(this._dir).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.db.Database");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

