/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.BuilderProgram;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.types.InitParam;
import com.caucho.config.types.Validator;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.naming.Jndi;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ResourceRef
implements Validator {
    private static Logger log = Logger.getLogger(ResourceRef._resin_compat_class_2().getName());
    private static L10N L = new L10N(ResourceRef._resin_compat_class_2());
    private String _location = "";
    private String _name;
    private Class _type;
    private String _description;
    private boolean _sharing;
    private BuilderProgram _init;
    private HashMap<String, String> _params = new HashMap();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;

    public void setId(String id) {
    }

    public void setConfigLocation(String filename, int line) {
        this._location = new CharBuffer().append(filename).append(":").append(line).append(" ").toString();
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setResRefName(String name) {
        this._name = name;
    }

    public String getResRefName() {
        return this._name;
    }

    public void setResType(Class type) {
        this._type = type;
    }

    public void setResAuth(String auth) {
    }

    public void setResSharingScope(String share) {
    }

    public void setClassName(Class type) {
        this._type = type;
    }

    public Class getResType() {
        return this._type;
    }

    public void setInit(BuilderProgram init) {
        this._init = init;
    }

    public BuilderProgram getInit() {
        return this._init;
    }

    public void setInitParam(InitParam initParam) {
        this._params.putAll(initParam.getParameters());
    }

    public void init() throws Throwable {
        if (this._init == null && this._params.size() == 0) {
            return;
        }
        Class cl = this._type;
        if (ResourceRef._resin_compat_class_0().equals(this._type)) {
            cl = ResourceRef._resin_compat_class_1();
        }
        Object obj = cl.newInstance();
        if (this._init != null) {
            this._init.configure(obj);
        }
        Iterator<String> iter = this._params.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            String value = this._params.get(key);
            Config.setAttribute(obj, key, value);
        }
        if (obj instanceof ClassLoaderListener) {
            ClassLoaderListener listener = (ClassLoaderListener)obj;
            for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
                if (!(loader instanceof EnvironmentClassLoader)) continue;
                ((DynamicClassLoader)loader).addListener(listener);
                break;
            }
        }
        Jndi.bindDeep(this._name, obj);
    }

    public void validate() throws ConfigException {
        Object obj = null;
        try {
            obj = new InitialContext().lookup(new CharBuffer().append("java:comp/env/").append(this._name).toString());
        }
        catch (NamingException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (obj == null) {
            throw this.error(L.l("resource-ref '{0}' was not configured.  All resources defined by <resource-ref> tags must be defined in a configuration file.", this._name));
        }
    }

    public ConfigException error(String msg) {
        if (this._location != null) {
            return new LineConfigException(new CharBuffer().append(this._location).append(msg).toString());
        }
        return new ConfigException(msg);
    }

    public String toString() {
        return new CharBuffer().append("ResourceRef[").append(this._name).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.sql.DataSource");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.sql.DBPool");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("com.caucho.config.types.ResourceRef");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

