/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.types.InitParam;
import com.caucho.config.types.InitProgram;
import com.caucho.naming.Jndi;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class ReferenceConfig {
    private static L10N L = new L10N(ReferenceConfig._resin_compat_class_1());
    private String _name;
    private Class _factory;
    private String _description;
    private InitProgram _init;
    private HashMap<String, String> _params;
    private ObjectFactory _objectFactory;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public void setJndiName(String name) {
        this._name = name;
    }

    public String getJndiName() {
        return this._name;
    }

    public Class getFactory() {
        return this._factory;
    }

    public void setFactory(Class factory) {
        this._factory = factory;
    }

    public void setInit(InitProgram init) {
        this._init = init;
    }

    public InitProgram getInit() {
        return this._init;
    }

    public void addInitParam(InitParam initParam) {
        if (this._params == null) {
            this._params = new HashMap();
        }
        this._params.putAll(initParam.getParameters());
    }

    public void init() throws Exception {
        Reference ref;
        Reference obj = null;
        if (this._factory == null) {
            throw new ConfigException(L.l("<reference> configuration need a <factory>.  The <factory> is the class name of the resource bean."));
        }
        if (ReferenceConfig._resin_compat_class_0().isAssignableFrom(this._factory)) {
            if (this._init != null) {
                throw new ConfigException(L.l("<init> is not allowed for object factories.  A <resource> with a <factory> must only have <init-param> configuration."));
            }
            String factoryName = this._factory.getName();
            ref = new Reference(factoryName, factoryName, null);
            if (this._params != null) {
                ArrayList<String> names = new ArrayList<String>(this._params.keySet());
                Collections.sort(names);
                for (int i = 0; i < names.size(); ++i) {
                    String name = names.get(i);
                    String value = this._params.get(name);
                    ref.add(new StringRefAddr(name, value));
                }
            }
        } else {
            throw new ConfigException(L.l("`{0}' must implement ObjectFactory.  <factory> classes in <resource> must implement ObjectFactory.", this._factory.getName()));
        }
        obj = ref;
        if (this._name.startsWith("java:comp")) {
            Jndi.bindDeep(this._name, obj);
        } else {
            Jndi.bindDeep(new CharBuffer().append("java:comp/env/").append(this._name).toString(), obj);
        }
    }

    protected void configure(Object obj) throws Throwable {
        if (this._init != null) {
            this._init.init(obj);
        }
    }

    public String toString() {
        return new CharBuffer().append("Resource[").append(this._name).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.naming.spi.ObjectFactory");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.config.types.ReferenceConfig");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

