/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.types.Validator;
import com.caucho.el.Expr;
import com.caucho.naming.Jndi;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class EnvEntry
implements Validator {
    private static final L10N L = new L10N(EnvEntry._resin_compat_class_9());
    private static final Logger log = Logger.getLogger(EnvEntry._resin_compat_class_9().getName());
    private String _location = "";
    private String _name;
    private Class _type;
    private String _value;
    private String _description;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;
    private static Class _resin_compat_class_6;
    private static Class _resin_compat_class_7;
    private static Class _resin_compat_class_8;
    private static Class _resin_compat_class_9;

    public void setId(String id) {
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setConfigLocation(String filename, int line) {
        this._location = new CharBuffer().append(filename).append(":").append(line).append(" ").toString();
    }

    public void setEnvEntryName(String name) {
        this._name = name;
    }

    public String getEnvEntryName() {
        return this._name;
    }

    public void setEnvEntryType(Class type) {
        this._type = type;
    }

    public Class getEnvEntryType() {
        return this._type;
    }

    public void setEnvEntryValue(String value) {
        this._value = value;
    }

    public String getEnvEntryValue() {
        return this._value;
    }

    public void init() throws Exception {
        if (this._name == null) {
            throw new ConfigException(L.l("env-entry needs `env-entry-name' attribute"));
        }
        if (this._type == null) {
            throw new ConfigException(L.l("env-entry needs `env-entry-type' attribute"));
        }
        if (this._value == null) {
            return;
        }
        Object value = this._value;
        if (!this._type.equals(EnvEntry._resin_compat_class_0())) {
            if (this._type.equals(EnvEntry._resin_compat_class_1())) {
                value = new Boolean(Expr.toBoolean(this._value, null));
            } else if (this._type.equals(EnvEntry._resin_compat_class_2())) {
                value = new Byte((byte)Expr.toLong(this._value, null));
            } else if (this._type.equals(EnvEntry._resin_compat_class_3())) {
                value = new Short((short)Expr.toLong(this._value, null));
            } else if (this._type.equals(EnvEntry._resin_compat_class_4())) {
                value = new Integer((int)Expr.toLong(this._value, null));
            } else if (this._type.equals(EnvEntry._resin_compat_class_5())) {
                value = new Long(Expr.toLong(this._value, null));
            } else if (this._type.equals(EnvEntry._resin_compat_class_6())) {
                value = new Float((float)Expr.toDouble(this._value, null));
            } else if (this._type.equals(EnvEntry._resin_compat_class_7())) {
                value = new Double(Expr.toDouble(this._value, null));
            } else if (this._type.equals(EnvEntry._resin_compat_class_8())) {
                String v = Expr.toString(this._value, null);
                value = v == null || v.length() == 0 ? null : new Character(v.charAt(0));
            }
        }
        if (this._name.startsWith("java:comp")) {
            Jndi.bindDeep(this._name, value);
        } else {
            Jndi.bindDeep(new CharBuffer().append("java:comp/env/").append(this._name).toString(), value);
        }
    }

    public void validate() throws ConfigException {
        Object obj = null;
        try {
            obj = new InitialContext().lookup(new CharBuffer().append("java:comp/env/").append(this._name).toString());
        }
        catch (NamingException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (obj == null) {
            throw this.error(L.l("env-entry '{0}' was not configured.  All resources defined by <env-entry> tags must be defined in a configuration file.", this._name));
        }
    }

    public ConfigException error(String msg) {
        if (this._location != null) {
            return new LineConfigException(new CharBuffer().append(this._location).append(msg).toString());
        }
        return new ConfigException(msg);
    }

    public String toString() {
        return new CharBuffer().append("EnvEntry[").append(this._name).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.lang.Boolean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("java.lang.Byte");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("java.lang.Short");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("java.lang.Integer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("java.lang.Long");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_6() {
        try {
            Class<?> clazz = _resin_compat_class_6;
            if (clazz == null) {
                clazz = _resin_compat_class_6 = Class.forName("java.lang.Float");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_7() {
        try {
            Class<?> clazz = _resin_compat_class_7;
            if (clazz == null) {
                clazz = _resin_compat_class_7 = Class.forName("java.lang.Double");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_8() {
        try {
            Class<?> clazz = _resin_compat_class_8;
            if (clazz == null) {
                clazz = _resin_compat_class_8 = Class.forName("java.lang.Character");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_9() {
        try {
            Class<?> clazz = _resin_compat_class_9;
            if (clazz == null) {
                clazz = _resin_compat_class_9 = Class.forName("com.caucho.config.types.EnvEntry");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

