/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;

public class Bytes {
    private static final L10N L = new L10N(Bytes._resin_compat_class_0());
    public static final long BYTE = 1L;
    public static final long KILOBYTE = 1024L;
    public static final long MEGABYTE = 0x100000L;
    public static final long GIGABYTE = 0x40000000L;
    public static final long INFINITE = 0x3FFFFFFFFFFFFFFFL;
    private long _bytes;
    private static Class _resin_compat_class_0;

    public Bytes() {
    }

    public Bytes(long bytes) {
        this._bytes = bytes;
    }

    public void addText(String text) throws ConfigException {
        this._bytes = Bytes.toBytes(text);
    }

    public long getBytes() {
        return this._bytes;
    }

    public static long toBytes(String bytes) throws ConfigException {
        char ch;
        if (bytes == null) {
            return -1L;
        }
        long value = 0L;
        long sign = 1L;
        int i = 0;
        int length = bytes.length();
        if (length == 0) {
            return -1L;
        }
        if (bytes.charAt(i) == '-') {
            sign = -1L;
            ++i;
        } else if (bytes.charAt(i) == '+') {
            ++i;
        }
        if (length <= i) {
            return -1L;
        }
        while (i < length && (ch = bytes.charAt(i)) >= '0' && ch <= '9') {
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        value = sign * value;
        if (bytes.endsWith("gb") || bytes.endsWith("g") || bytes.endsWith("G")) {
            return value * 1024L * 1024L * 1024L;
        }
        if (bytes.endsWith("mb") || bytes.endsWith("m") || bytes.endsWith("M")) {
            return value * 1024L * 1024L;
        }
        if (bytes.endsWith("kb") || bytes.endsWith("k") || bytes.endsWith("K")) {
            return value * 1024L;
        }
        if (bytes.endsWith("b") || bytes.endsWith("B")) {
            return value;
        }
        if (value < 0L) {
            return value;
        }
        throw new ConfigException(L.l("byte-valued expression `{0}' must have units.  '16B' for bytes, '16K' for kilobytes, '16M' for megabytes, '16G' for gigabytes.", bytes));
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.config.types.Bytes");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

