/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.core;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.config.core.ResinControl;
import com.caucho.config.types.FileSetType;
import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ResinImport
extends ResinControl {
    private static final L10N L = new L10N(ResinImport._resin_compat_class_0());
    private static final Logger log = Log.open(ResinImport._resin_compat_class_0());
    private Path _path;
    private FileSetType _fileSet;
    private boolean _isOptional;
    private static Class _resin_compat_class_0;

    public void setPath(Path path) {
        this._path = path;
    }

    public void setFileset(FileSetType fileSet) {
        this._fileSet = fileSet;
    }

    public void setOptional(boolean optional) {
        this._isOptional = optional;
    }

    public void init() throws Exception {
        ArrayList<Path> paths;
        if (this._path == null) {
            if (this._fileSet == null) {
                throw new ConfigException(L.l("'path' attribute missing from resin:import."));
            }
        } else if (!this._path.canRead() || this._path.isDirectory()) {
            if (this._isOptional) {
                log.finer(L.l("resin:import '{0}' is not readable.", this._path));
                Environment.addDependency(new Depend(this._path));
                return;
            }
            throw new ConfigException(L.l("Required file '{0}' can not be read for resin:import.", this._path.getNativePath()));
        }
        Object object = this.getObject();
        String schema = null;
        if (object instanceof SchemaBean) {
            schema = ((SchemaBean)object).getSchema();
        }
        if (this._fileSet != null) {
            paths = this._fileSet.getPaths();
        } else {
            paths = new ArrayList();
            paths.add(this._path);
        }
        for (int i = 0; i < paths.size(); ++i) {
            Path path = paths.get(i);
            log.config(L.l("resin:import '{0}'", path.getNativePath()));
            Environment.addDependency(new Depend(path));
            Config config = new Config();
            config.configureBean(object, path, schema);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.config.core.ResinImport");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

