/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.AttributeStrategy;
import com.caucho.config.BeanTypeStrategy;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.EnvironmentAttributeStrategy;
import com.caucho.config.EnvironmentTypeStrategy;
import com.caucho.config.NodeBuilder;
import com.caucho.config.NodeBuilderChildProgram;
import com.caucho.config.NodeBuilderProgram;
import com.caucho.config.TypeStrategy;
import com.caucho.config.types.ClassTypeStrategy;
import com.caucho.config.types.InitProgram;
import com.caucho.config.types.RawString;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.xml.QName;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class TypeStrategyFactory {
    private static final Logger log = Log.open(TypeStrategyFactory._resin_compat_class_1());
    private static L10N L = new L10N(TypeStrategyFactory._resin_compat_class_1());
    private static final HashMap<String, TypeStrategy> _primitiveTypes = new HashMap();
    private static final EnvironmentLocal<TypeStrategyFactory> _localFactory = new EnvironmentLocal();
    private final HashMap<String, TypeStrategy> _typeMap = new HashMap();
    private final HashMap<QName, AttributeStrategy> _flowMap = new HashMap();
    private final HashMap<QName, AttributeStrategy> _envMap = new HashMap();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    private TypeStrategyFactory() {
    }

    public static TypeStrategy getTypeStrategy(Class type) throws Exception {
        TypeStrategyFactory factory = TypeStrategyFactory.getFactory(type.getClassLoader());
        return factory.getTypeStrategyImpl(type);
    }

    public static AttributeStrategy getFlowAttribute(Class type, QName name) throws Exception {
        return TypeStrategyFactory.getFactory(type.getClassLoader()).getFlowAttribute(name);
    }

    private AttributeStrategy getFlowAttribute(QName name) {
        return this._flowMap.get(name);
    }

    public static AttributeStrategy getEnvironmentAttribute(Class type, QName name) throws Exception {
        return TypeStrategyFactory.getFactory(type.getClassLoader()).getEnvironmentAttribute(name);
    }

    private AttributeStrategy getEnvironmentAttribute(QName name) {
        AttributeStrategy strategy = this._envMap.get(name);
        if (strategy != null) {
            return strategy;
        }
        if (name.getLocalName() != null && !name.getLocalName().equals("")) {
            return this._envMap.get(new QName(name.getLocalName(), null));
        }
        return null;
    }

    private static TypeStrategyFactory getFactory(ClassLoader loader) throws Exception {
        TypeStrategyFactory factory;
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if ((factory = _localFactory.getLevel(loader)) == null) {
            factory = new TypeStrategyFactory();
            _localFactory.set(factory, loader);
            factory.init(loader);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ClassLoader loader) throws Exception {
        Enumeration<URL> urls = loader.getResources("META-INF/caucho/config-types.xml");
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream is = url.openStream();
            try {
                new Config(loader).configure((Object)this, is);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                is.close();
            }
        }
    }

    public void addTypeStrategy(TypeStrategyConfig config) {
        this._typeMap.put(config.getName(), config.getType());
    }

    public FlowAttributeConfig createFlowAttribute() {
        return new FlowAttributeConfig();
    }

    public EnvironmentAttributeConfig createEnvironmentAttribute() {
        return new EnvironmentAttributeConfig();
    }

    private TypeStrategy getTypeStrategyImpl(Class type) {
        TypeStrategy strategy = this._typeMap.get(type.getName());
        if (strategy == null) {
            strategy = _primitiveTypes.get(type.getName());
            if (strategy == null) {
                strategy = TypeStrategyFactory._resin_compat_class_0().isAssignableFrom(type) ? new EnvironmentTypeStrategy(type) : new BeanTypeStrategy(type);
            }
            this._typeMap.put(type.getName(), strategy);
        }
        return strategy;
    }

    static {
        _primitiveTypes.put("boolean", new PrimitiveBooleanTypeStrategy());
        _primitiveTypes.put("byte", new PrimitiveByteTypeStrategy());
        _primitiveTypes.put("short", new PrimitiveShortTypeStrategy());
        _primitiveTypes.put("int", new PrimitiveIntTypeStrategy());
        _primitiveTypes.put("long", new PrimitiveLongTypeStrategy());
        _primitiveTypes.put("float", new PrimitiveFloatTypeStrategy());
        _primitiveTypes.put("double", new PrimitiveDoubleTypeStrategy());
        _primitiveTypes.put("char", new PrimitiveCharTypeStrategy());
        _primitiveTypes.put("java.lang.Boolean", new BooleanTypeStrategy());
        _primitiveTypes.put("java.lang.Byte", new ByteTypeStrategy());
        _primitiveTypes.put("java.lang.Short", new ShortTypeStrategy());
        _primitiveTypes.put("java.lang.Integer", new IntegerTypeStrategy());
        _primitiveTypes.put("java.lang.Long", new LongTypeStrategy());
        _primitiveTypes.put("java.lang.Float", new FloatTypeStrategy());
        _primitiveTypes.put("java.lang.Double", new DoubleTypeStrategy());
        _primitiveTypes.put("java.lang.Character", new CharacterTypeStrategy());
        _primitiveTypes.put("java.lang.Object", new ObjectTypeStrategy());
        _primitiveTypes.put("java.lang.String", new StringTypeStrategy());
        _primitiveTypes.put("com.caucho.config.types.RawString", new RawStringTypeStrategy());
        _primitiveTypes.put("org.w3c.dom.Node", new NodeTypeStrategy());
        _primitiveTypes.put("java.lang.Class", new ClassTypeStrategy());
        _primitiveTypes.put("com.caucho.config.types.InitProgram", new InitProgramTypeStrategy());
        _primitiveTypes.put("com.caucho.config.BuilderProgram", new BuilderProgramTypeStrategy());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.loader.EnvironmentBean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.config.TypeStrategyFactory");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static class BuilderProgramTypeStrategy
    extends TypeStrategy {
        private BuilderProgramTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            return new NodeBuilderChildProgram(builder, node);
        }
    }

    private static class InitProgramTypeStrategy
    extends TypeStrategy {
        private InitProgramTypeStrategy() {
        }

        public void configureBean(NodeBuilder builder, Object bean, Node node) throws Exception {
            InitProgram program = (InitProgram)bean;
            program.addBuilderProgram(new NodeBuilderProgram(builder, node));
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            return new InitProgram(new NodeBuilderProgram(builder, node));
        }
    }

    private static class ObjectTypeStrategy
    extends TypeStrategy {
        private ObjectTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            return builder.configureObject(node, parent);
        }
    }

    private static class NodeTypeStrategy
    extends TypeStrategy {
        private NodeTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            return node;
        }
    }

    private static class RawStringTypeStrategy
    extends TypeStrategy {
        private RawStringTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            return new RawString(builder.configureRawString(node));
        }
    }

    private static class StringTypeStrategy
    extends TypeStrategy {
        private StringTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            return builder.configureString(node);
        }
    }

    private static class CharacterTypeStrategy
    extends TypeStrategy {
        private CharacterTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureString(node);
            if (value == null || value.length() == 0) {
                return null;
            }
            if (value.length() == 1) {
                return new Character(value.charAt(0));
            }
            throw NodeBuilder.error(L.l("Character must be a single char '{0}'", value), node);
        }
    }

    private static class DoubleTypeStrategy
    extends TypeStrategy {
        private DoubleTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureString(node);
            if (value == null || value.equals("")) {
                return null;
            }
            return new Double(value);
        }
    }

    private static class FloatTypeStrategy
    extends TypeStrategy {
        private FloatTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureString(node);
            if (value == null || value.equals("")) {
                return null;
            }
            return new Float(value);
        }
    }

    private static class LongTypeStrategy
    extends TypeStrategy {
        private LongTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureString(node);
            if (value == null || value.equals("")) {
                return null;
            }
            return new Long(value);
        }
    }

    private static class IntegerTypeStrategy
    extends TypeStrategy {
        private IntegerTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureString(node);
            if (value == null || value.equals("")) {
                return null;
            }
            return new Integer(value);
        }
    }

    private static class ShortTypeStrategy
    extends TypeStrategy {
        private ShortTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureString(node);
            if (value == null || value.equals("")) {
                return null;
            }
            return new Short(value);
        }
    }

    private static class ByteTypeStrategy
    extends TypeStrategy {
        private ByteTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureString(node);
            if (value == null || value.equals("")) {
                return null;
            }
            return new Byte(value);
        }
    }

    private static class BooleanTypeStrategy
    extends TypeStrategy {
        private BooleanTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureRawString(node);
            if (value == null || value.equals("")) {
                return null;
            }
            return builder.evalBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private static class PrimitiveCharTypeStrategy
    extends TypeStrategy {
        private PrimitiveCharTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureString(node);
            if (value == null || value.length() == 0) {
                return new Character('\u0000');
            }
            if (value.length() == 1) {
                return new Character(value.charAt(0));
            }
            throw NodeBuilder.error(L.l("Character must be a single char '{0}'", value), node);
        }
    }

    private static class PrimitiveDoubleTypeStrategy
    extends TypeStrategy {
        private PrimitiveDoubleTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureString(node);
            if (value == null || value.equals("")) {
                return new Double(0.0);
            }
            return new Double(value);
        }
    }

    private static class PrimitiveFloatTypeStrategy
    extends TypeStrategy {
        private PrimitiveFloatTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureString(node);
            if (value == null || value.equals("")) {
                return new Float(0.0f);
            }
            return new Float(value);
        }
    }

    private static class PrimitiveLongTypeStrategy
    extends TypeStrategy {
        private PrimitiveLongTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureString(node);
            if (value == null || value.equals("")) {
                return new Long(0L);
            }
            return new Long(value);
        }
    }

    private static class PrimitiveIntTypeStrategy
    extends TypeStrategy {
        private PrimitiveIntTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureString(node);
            if (value == null || value.equals("")) {
                return new Integer(0);
            }
            return new Integer(value);
        }
    }

    private static class PrimitiveShortTypeStrategy
    extends TypeStrategy {
        private PrimitiveShortTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureString(node);
            if (value == null || value.equals("")) {
                return new Short(0);
            }
            return new Short(value);
        }
    }

    private static class PrimitiveByteTypeStrategy
    extends TypeStrategy {
        private PrimitiveByteTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureString(node);
            if (value == null || value.equals("")) {
                return new Byte(0);
            }
            return new Byte(value);
        }
    }

    private static class PrimitiveBooleanTypeStrategy
    extends TypeStrategy {
        private PrimitiveBooleanTypeStrategy() {
        }

        public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
            String value = builder.configureRawString(node);
            if (value == null || value.equals("")) {
                return Boolean.TRUE;
            }
            return builder.evalBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public class FlowAttributeConfig {
        public void put(QName name, Class type) {
            TypeStrategy typeStrategy = TypeStrategyFactory.this.getTypeStrategyImpl(type);
            TypeStrategyFactory.this._flowMap.put(name, new EnvironmentAttributeStrategy(typeStrategy));
        }
    }

    public class EnvironmentAttributeConfig {
        public void put(QName name, Class type) {
            TypeStrategy typeStrategy = TypeStrategyFactory.this.getTypeStrategyImpl(type);
            TypeStrategyFactory.this._envMap.put(name, new EnvironmentAttributeStrategy(typeStrategy));
        }
    }

    public static class TypeStrategyConfig {
        private String _name;
        private TypeStrategy _type;
        private static Class _resin_compat_class_0;

        public void setName(Class type) {
            this._name = type.getName();
        }

        public String getName() {
            return this._name;
        }

        public void setType(Class type) throws ConfigException, IllegalAccessException, InstantiationException {
            Config.validate(type, TypeStrategyConfig._resin_compat_class_0());
            this._type = (TypeStrategy)type.newInstance();
        }

        public TypeStrategy getType() {
            return this._type;
        }

        private static Class _resin_compat_class_0() {
            try {
                Class<?> clazz = _resin_compat_class_0;
                if (clazz == null) {
                    clazz = _resin_compat_class_0 = Class.forName("com.caucho.config.TypeStrategy");
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }
}

