/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.AttributeStrategy;
import com.caucho.config.ConfigException;
import com.caucho.config.ConfigVariableResolver;
import com.caucho.config.LineConfigException;
import com.caucho.config.TypeStrategy;
import com.caucho.config.TypeStrategyFactory;
import com.caucho.config.types.ResinType;
import com.caucho.config.types.Validator;
import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.util.CharBuffer;
import com.caucho.util.CompileException;
import com.caucho.util.L10N;
import com.caucho.util.LineCompileException;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QDocument;
import com.caucho.xml.QElement;
import com.caucho.xml.QName;
import com.caucho.xml.QNode;
import com.caucho.xml.XmlUtil;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.el.ELException;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeBuilder {
    private static final L10N L = new L10N(NodeBuilder._resin_compat_class_0());
    private static final Logger log = Log.open(NodeBuilder._resin_compat_class_0());
    private static final QName RESIN_TYPE = new QName("resin:type");
    private static final QName RESIN_TYPE_NS = new QName("resin:type", "http://caucho.com/ns/resin/core");
    private static ThreadLocal<NodeBuilder> _currentBuilder = new ThreadLocal();
    private ArrayList<ValidatorEntry> _validators = new ArrayList();
    private ConfigVariableResolver _varResolver = new ConfigVariableResolver();
    private static Class _resin_compat_class_0;

    public static NodeBuilder getCurrentBuilder() {
        return _currentBuilder.get();
    }

    static void setCurrentBuilder(NodeBuilder builder) {
        _currentBuilder.set(builder);
    }

    public Object configure(Object bean, Node top) throws LineConfigException {
        NodeBuilder oldBuilder = _currentBuilder.get();
        try {
            _currentBuilder.set(this);
            if (top instanceof QNode) {
                this._varResolver.put("__FILE__", (Object)((QNode)top).getBaseURI());
            }
            TypeStrategy typeStrategy = TypeStrategyFactory.getTypeStrategy(bean.getClass());
            Object object = this.configureImpl(typeStrategy, bean, top);
            return object;
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw NodeBuilder.error(e, top);
        }
        finally {
            _currentBuilder.set(oldBuilder);
        }
    }

    public void configureBean(Object bean, Node top) throws LineConfigException {
        NodeBuilder oldBuilder = _currentBuilder.get();
        try {
            _currentBuilder.set(this);
            if (top instanceof QNode) {
                this._varResolver.put("__FILE__", (Object)((QNode)top).getBaseURI());
            }
            TypeStrategy typeStrategy = TypeStrategyFactory.getTypeStrategy(bean.getClass());
            typeStrategy.configureBean(this, bean, top);
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw NodeBuilder.error(e, top);
        }
        finally {
            _currentBuilder.set(oldBuilder);
        }
    }

    public void configureAttribute(Object bean, Node attribute) throws LineConfigException {
        String attrName = attribute.getNodeName();
        if (attrName.equals("resin:type")) {
            return;
        }
        if (attrName.startsWith("xmlns")) {
            return;
        }
        NodeBuilder oldBuilder = NodeBuilder.getCurrentBuilder();
        try {
            NodeBuilder.setCurrentBuilder(this);
            TypeStrategy typeStrategy = TypeStrategyFactory.getTypeStrategy(bean.getClass());
            typeStrategy.configureAttribute(this, bean, attribute);
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw NodeBuilder.error(e, attribute);
        }
        finally {
            NodeBuilder.setCurrentBuilder(oldBuilder);
        }
    }

    Object configureImpl(TypeStrategy typeStrategy, Object bean, Node top) throws LineConfigException {
        try {
            typeStrategy.configureBean(this, bean, top);
            typeStrategy.init(bean);
            return typeStrategy.replaceObject(bean);
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw NodeBuilder.error(e, top);
        }
    }

    Object configureChildImpl(TypeStrategy typeStrategy, Node top, Object parent) throws Exception {
        String value;
        Object bean = this.createResinType(top);
        if (bean == null && !NodeBuilder.hasChildren(top) && (value = NodeBuilder.textValue(top)) != null && value.startsWith("${") && value.endsWith("}")) {
            bean = this.evalObject(value);
            return bean;
        }
        if (bean == null) {
            bean = typeStrategy.create();
        }
        typeStrategy = TypeStrategyFactory.getTypeStrategy(bean.getClass());
        typeStrategy.setParent(bean, parent);
        return this.configureImpl(typeStrategy, bean, top);
    }

    void configureBeanImpl(TypeStrategy typeStrategy, Object bean, Node top) throws Exception {
        if (top instanceof Attr || top instanceof CharacterData) {
            QName qName = new QName("#text");
            AttributeStrategy attrStrategy = typeStrategy.getAttributeStrategy(qName);
            attrStrategy.configure(this, bean, qName, top);
            return;
        }
        NamedNodeMap attrList = top.getAttributes();
        if (attrList != null) {
            int length = attrList.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = attrList.item(i);
                this.configureAttributeImpl(typeStrategy, bean, child);
            }
        }
        for (Node child = top.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.configureAttributeImpl(typeStrategy, bean, child);
        }
    }

    void configureAttributeImpl(TypeStrategy typeStrategy, Object bean, Node node) throws Exception {
        try {
            QName qName = ((QAbstractNode)node).getQName();
            if (node instanceof Comment) {
                return;
            }
            if (node instanceof ProcessingInstruction) {
                return;
            }
            if (node instanceof CharacterData) {
                String data = ((CharacterData)node).getData();
                if (XmlUtil.isWhitespace(data)) {
                    return;
                }
                qName = new QName("#text");
            }
            if (qName.getName().startsWith("xmlns")) {
                return;
            }
            if (qName.getName().equals("resin:type")) {
                return;
            }
            AttributeStrategy attrStrategy = typeStrategy.getAttributeStrategy(qName);
            attrStrategy.configure(this, bean, qName, node);
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw NodeBuilder.error(e, node);
        }
    }

    ArrayList<Dependency> getDependencyList(Node node) {
        QElement qelt;
        ArrayList<Path> pathList;
        ArrayList<Depend> dependList = null;
        if (node instanceof QElement && (pathList = ((QDocument)(qelt = (QElement)node).getOwnerDocument()).getDependList()) != null) {
            dependList = new ArrayList<Depend>();
            for (int i = 0; i < pathList.size(); ++i) {
                dependList.add(new Depend(pathList.get(i)));
            }
        }
        return dependList;
    }

    public Object configureObject(Node node, Object parent) throws Exception {
        Object resinTypeValue = this.createResinType(node);
        if (resinTypeValue != null) {
            Class<?> type = resinTypeValue.getClass();
            TypeStrategy typeStrategy = TypeStrategyFactory.getTypeStrategy(type);
            typeStrategy.setParent(resinTypeValue, parent);
            return this.configureImpl(typeStrategy, resinTypeValue, node);
        }
        if (NodeBuilder.hasChildren(node)) {
            throw NodeBuilder.error(L.l("unexpected node {0}", node.getNodeName()), node);
        }
        String value = NodeBuilder.textValue(node);
        if (value == null) {
            return null;
        }
        if (value.indexOf("${") >= 0) {
            return this.evalObject(value);
        }
        return value;
    }

    public String configureString(Node child) throws Exception {
        String value = this.configureRawString(child);
        if (value == null) {
            return "";
        }
        if (value.indexOf("${") >= 0) {
            return this.evalString(value);
        }
        return value;
    }

    public String configureRawString(Node child) throws Exception {
        Object resinTypeValue = this.createResinType(child);
        if (resinTypeValue != null) {
            TypeStrategy typeStrategy = TypeStrategyFactory.getTypeStrategy(resinTypeValue.getClass());
            return String.valueOf(this.configureImpl(typeStrategy, resinTypeValue, child));
        }
        if (NodeBuilder.hasChildren(child)) {
            throw NodeBuilder.error(L.l("unexpected child nodes"), child);
        }
        String value = NodeBuilder.textValue(child);
        return value;
    }

    Object createResinType(Node child) throws Exception {
        String type = NodeBuilder.getValue(RESIN_TYPE, child, null);
        if ((type = NodeBuilder.getValue(RESIN_TYPE_NS, child, type)) == null) {
            return null;
        }
        ResinType resinType = null;
        resinType = new ResinType();
        resinType.addText(type);
        resinType.init();
        return resinType.create(null);
    }

    Object configureCreate(Class type, Node node) throws Exception {
        Object value = type.newInstance();
        return this.configure(value, node);
    }

    public ConfigVariableResolver getConfigVariableResolver() {
        return this._varResolver;
    }

    public Object putVar(String name, Object value) {
        return this._varResolver.put(name, value);
    }

    public Object getVar(String name) {
        return this._varResolver.get(name);
    }

    void addValidator(Validator validator) {
        this._validators.add(new ValidatorEntry(validator));
    }

    static boolean hasChildren(Node node) {
        NamedNodeMap attrList = node.getAttributes();
        if (attrList != null) {
            for (int i = 0; i < attrList.getLength(); ++i) {
                if (attrList.item(i).getNodeName().startsWith("xml")) continue;
                return true;
            }
        }
        for (Node ptr = node.getFirstChild(); ptr != null; ptr = ptr.getNextSibling()) {
            if (!(ptr instanceof Element)) continue;
            return true;
        }
        return false;
    }

    static String getValue(QName name, Node node, String defaultValue) {
        NamedNodeMap attrList = node.getAttributes();
        if (attrList != null) {
            for (int i = 0; i < attrList.getLength(); ++i) {
                if (!attrList.item(i).getNodeName().equals(name.getName())) continue;
                return attrList.item(i).getNodeValue();
            }
        }
        for (Node ptr = node.getFirstChild(); ptr != null; ptr = ptr.getNextSibling()) {
            QName qName = ((QAbstractNode)ptr).getQName();
            if (!name.equals(qName)) continue;
            return NodeBuilder.textValue(ptr);
        }
        return defaultValue;
    }

    static String textValue(Node node) {
        String space;
        if (node instanceof Attr) {
            return node.getNodeValue();
        }
        String value = XmlUtil.textValue(node);
        if (value.equals("")) {
            return "";
        }
        if (node instanceof Element && !(space = ((Element)node).getAttribute("xml:space")).equals("")) {
            return value;
        }
        return value.trim();
    }

    public String evalString(String exprString) throws ELException {
        if (exprString.indexOf("${") >= 0) {
            ELParser parser = new ELParser(exprString);
            parser.setCheckEscape(true);
            Expr expr = parser.parse();
            return expr.evalString(this.getConfigVariableResolver());
        }
        return exprString;
    }

    public boolean evalBoolean(String exprString) throws ELException {
        if (exprString.indexOf("${") >= 0) {
            ELParser parser = new ELParser(exprString);
            parser.setCheckEscape(true);
            Expr expr = parser.parse();
            return expr.evalBoolean(this.getConfigVariableResolver());
        }
        return Expr.toBoolean(exprString, null);
    }

    public Object evalObject(String exprString) throws ELException {
        if (exprString.indexOf("${") >= 0) {
            ELParser parser = new ELParser(exprString);
            parser.setCheckEscape(true);
            Expr expr = parser.parse();
            return expr.evalObject(this.getConfigVariableResolver());
        }
        return exprString;
    }

    static LineConfigException error(String msg, Node node) {
        String filename = null;
        int line = 0;
        if (node instanceof QAbstractNode) {
            QAbstractNode qnode = (QAbstractNode)node;
            filename = qnode.getFilename();
            line = qnode.getLine();
        }
        if (filename != null) {
            return new LineConfigException(new CharBuffer().append(filename).append(":").append(line).append(": ").append(msg).toString());
        }
        return new LineConfigException(msg);
    }

    private static LineConfigException error(Throwable e, Node node) {
        String msg;
        String filename = null;
        int line = 0;
        if (node instanceof QAbstractNode) {
            QAbstractNode qnode = (QAbstractNode)node;
            filename = qnode.getFilename();
            line = qnode.getLine();
        }
        while (e.getCause() != null && !(e instanceof LineCompileException) && !(e instanceof CompileException)) {
            e = e.getCause();
        }
        if (e instanceof LineConfigException) {
            return (LineConfigException)e;
        }
        if (e instanceof ConfigException && e.getMessage() != null && filename != null) {
            msg = new CharBuffer().append(filename).append(":").append(line).append(": ").append(e.getMessage()).toString();
            return new LineConfigException(msg, e);
        }
        if (e instanceof LineCompileException) {
            return new LineConfigException(e.getMessage(), e);
        }
        if (e instanceof CompileException && e.getMessage() != null) {
            msg = new CharBuffer().append(filename).append(":").append(line).append(": ").append(e.getMessage()).toString();
            return new LineConfigException(msg, e);
        }
        log.log(Level.CONFIG, e.toString(), e);
        msg = new CharBuffer().append(filename).append(":").append(line).append(": ").append(e).toString();
        return new LineConfigException(msg, e);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.config.NodeBuilder");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class ValidatorEntry {
        private Validator _validator;
        private ClassLoader _loader;

        ValidatorEntry(Validator validator) {
            this._validator = validator;
            this._loader = Thread.currentThread().getContextClassLoader();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void validate() throws ConfigException {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this._loader);
                this._validator.validate();
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
        }
    }
}

