/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.AttributeStrategy;
import com.caucho.config.ConfigException;
import com.caucho.config.NodeBuilder;
import com.caucho.config.TypeStrategy;
import com.caucho.config.TypeStrategyFactory;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBuilder {
    private static final L10N L = new L10N(MapBuilder._resin_compat_class_0());
    private static final Logger log = Log.open(MapBuilder._resin_compat_class_0());
    private static Class _resin_compat_class_0;

    public static Object configure(Object bean, Map<String, Object> map) throws ConfigException {
        return MapBuilder.configure(bean, map, true);
    }

    public static Object configureNoInit(Object bean, Map<String, Object> map) throws ConfigException {
        return MapBuilder.configure(bean, map, false);
    }

    public static Object configure(Object bean, Map<String, Object> map, boolean doInit) throws ConfigException {
        NodeBuilder oldBuilder = NodeBuilder.getCurrentBuilder();
        try {
            if (oldBuilder == null) {
                NodeBuilder.setCurrentBuilder(new NodeBuilder());
            }
            TypeStrategy type = TypeStrategyFactory.getTypeStrategy(bean.getClass());
            Object object = MapBuilder.configure(type, bean, map, doInit);
            return object;
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ConfigException(e);
        }
        finally {
            NodeBuilder.setCurrentBuilder(oldBuilder);
        }
    }

    private static Object configure(TypeStrategy typeStrategy, Object bean, Map<String, Object> map, boolean doInit) throws Throwable {
        for (String key : map.keySet()) {
            QName attrName = new QName(key);
            AttributeStrategy attrStrategy = typeStrategy.getAttributeStrategy(attrName);
            if (attrStrategy == null) continue;
            attrStrategy.setAttribute(bean, attrName, map.get(key));
        }
        if (doInit) {
            typeStrategy.init(bean);
            return typeStrategy.replaceObject(bean);
        }
        return bean;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.config.MapBuilder");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

