/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.el.AbstractVariableResolver;
import com.caucho.el.EL;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import java.util.HashMap;

public class ConfigVariableResolver
extends AbstractVariableResolver {
    private HashMap<String, Object> _varMap = new HashMap();
    private ClassLoader _originalLoader;
    private ClassLoader _configureClassLoader;

    public ConfigVariableResolver() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ConfigVariableResolver(ClassLoader loader) {
        super(EL.getEnvironment(loader));
        this._originalLoader = loader;
    }

    ClassLoader getConfigLoader() {
        return this._configureClassLoader;
    }

    void setConfigLoader(ClassLoader loader) {
        if (this._configureClassLoader == null) {
            this._configureClassLoader = loader;
        }
    }

    public Object resolveVariable(String var) {
        Object value;
        ClassLoader loader;
        for (loader = Thread.currentThread().getContextClassLoader(); loader != this._originalLoader && loader != null; loader = loader.getParent()) {
            if (!(loader instanceof EnvironmentClassLoader)) continue;
            value = EL.getLevelVar(var, loader);
            if (value == EL.NULL) {
                return null;
            }
            if (value == null) continue;
            return value;
        }
        if (loader == this._configureClassLoader) {
            value = EL.getLevelVar(var, loader);
            if (value == EL.NULL) {
                return null;
            }
            if (value != null) {
                return value;
            }
        }
        if ((value = this._varMap.get(var)) == EL.NULL) {
            return null;
        }
        if (value != null) {
            return value;
        }
        value = Environment.getAttribute(var, this._originalLoader);
        if (value == EL.NULL) {
            return null;
        }
        if (value != null) {
            return value;
        }
        return super.resolveVariable(var);
    }

    public Object put(String name, Object value) {
        ClassLoader loader;
        for (loader = Thread.currentThread().getContextClassLoader(); loader != this._originalLoader && loader != null; loader = loader.getParent()) {
            if (!(loader instanceof EnvironmentClassLoader)) continue;
            return EL.putVar(name, value, loader);
        }
        if (loader == this._configureClassLoader) {
            return EL.putVar(name, value, loader);
        }
        return this._varMap.put(name, value);
    }

    public String toString() {
        return "ConfigVariableResolver[]";
    }
}

