/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.bytecode.compat.Box;
import com.caucho.config.AttributeStrategy;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.CreateAttributeStrategy;
import com.caucho.config.NodeBuilder;
import com.caucho.config.PrimitivePropertyStrategy;
import com.caucho.config.ProgramAttributeStrategy;
import com.caucho.config.QNameMapAttributeStrategy;
import com.caucho.config.SetterAttributeStrategy;
import com.caucho.config.TypeStrategy;
import com.caucho.config.TypeStrategyFactory;
import com.caucho.config.types.Validator;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.NotImplementedException;
import com.caucho.vfs.Depend;
import com.caucho.xml.QName;
import com.caucho.xml.QNode;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.jsp.el.VariableResolver;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanTypeStrategy
extends TypeStrategy {
    protected static final L10N L = new L10N(BeanTypeStrategy._resin_compat_class_6());
    private SoftReference<Method[]> _methodsRef;
    private HashMap<QName, AttributeStrategy> _nsAttributeMap = new HashMap();
    private final Class _type;
    private final Method _setParent;
    private final Method _setLocation;
    private final Method _addDependency;
    private final Method _setSystemId;
    private final Method _setNode;
    private final Method _init;
    private final Method _replaceObject;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;
    private static Class _resin_compat_class_6;

    BeanTypeStrategy(Class type) {
        this._type = type;
        Method setParent = null;
        this._setParent = setParent = this.findMethod("setParent", new Class[]{null});
        this._init = this.findMethod("init", new Class[0]);
        this._replaceObject = this.findMethod("replaceObject", new Class[0]);
        this._setLocation = this.findMethod("setConfigLocation", new Class[]{BeanTypeStrategy._resin_compat_class_0(), Integer.TYPE});
        this._addDependency = this.findMethod("addDependency", new Class[]{BeanTypeStrategy._resin_compat_class_1()});
        this._setSystemId = this.findMethod("setConfigSystemId", new Class[]{BeanTypeStrategy._resin_compat_class_0()});
        this._setNode = this.findMethod("setConfigNode", new Class[]{BeanTypeStrategy._resin_compat_class_2()});
    }

    public Class getType() {
        return this._type;
    }

    @Override
    public String getTypeName() {
        return this.getType().getName();
    }

    @Override
    public Object create() throws Exception {
        Object bean = this._type.newInstance();
        return bean;
    }

    @Override
    public void setParent(Object bean, Object parent) throws Exception {
        if (this._setParent != null) {
            try {
                if (parent != null && this._setParent.getParameterTypes()[0].isAssignableFrom(parent.getClass())) {
                    this._setParent.invoke(bean, parent);
                }
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
        }
    }

    @Override
    public AttributeStrategy getAttributeStrategy(QName attrName) throws Exception {
        AttributeStrategy strategy = this._nsAttributeMap.get(attrName);
        if (strategy == null) {
            strategy = this.getAttributeStrategyImpl(attrName);
            if (strategy == null && attrName.getName().equals("#text") && (strategy = this.getAttributeStrategyImpl(new QName("text"))) == null) {
                strategy = this.getAttributeStrategyImpl(new QName("value"));
            }
            if (strategy == null) {
                throw new ConfigException(L.l("'{0}' is an unknown property of '{1}'.", (Object)attrName.getName(), this._type.getName()));
            }
            this._nsAttributeMap.put(attrName, strategy);
        }
        return strategy;
    }

    @Override
    public Object configure(NodeBuilder builder, Node node, Object parent) throws Exception {
        return builder.configureChildImpl(this, node, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configureBean(NodeBuilder builder, Object bean, Node node) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            if (node instanceof QNode) {
                QNode qNode = (QNode)node;
                if (this._setNode != null) {
                    this._setNode.invoke(bean, qNode);
                }
                if (this._setLocation != null) {
                    this._setLocation.invoke(bean, qNode.getFilename(), Box.boxInteger(qNode.getLine()));
                }
                if (this._setSystemId != null) {
                    this._setSystemId.invoke(bean, qNode.getBaseURI());
                }
                if (this._addDependency != null) {
                    ArrayList<Depend> dependList = qNode.getDependencyList();
                    for (int i = 0; dependList != null && i < dependList.size(); ++i) {
                        this._addDependency.invoke(bean, dependList.get(i));
                    }
                }
            }
            super.configureBean(builder, bean, node);
            if (bean instanceof Validator) {
                builder.addValidator((Validator)bean);
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected AttributeStrategy getAttributeStrategyImpl(QName qName) throws Exception {
        String name = qName.getName();
        AttributeStrategy strategy = null;
        Method builderMethod = this.findProgramBuilderMethod();
        AttributeStrategy flow = this.getFlowAttribute(qName);
        if (flow != null) {
            if (builderMethod != null) {
                return new ProgramAttributeStrategy(builderMethod);
            }
            return flow;
        }
        if (name.equals("#text")) {
            name = "text";
        }
        Method setterMethod = this.findOneArgSetter(name);
        Method createMethod = this.findCreate(name);
        if (createMethod != null) {
            return new CreateAttributeStrategy(createMethod, setterMethod);
        }
        if (setterMethod != null) {
            strategy = new SetterAttributeStrategy(setterMethod);
            return strategy;
        }
        if (builderMethod != null) {
            return new ProgramAttributeStrategy(builderMethod);
        }
        strategy = this.getEnvironmentAttribute(qName);
        if (strategy != null) {
            return strategy;
        }
        Method method = this.findSetPropertyMethod();
        if (method != null) {
            if (BeanTypeStrategy._resin_compat_class_3().isAssignableFrom(method.getParameterTypes()[0])) {
                return new QNameMapAttributeStrategy(method, qName);
            }
            return new PrimitivePropertyStrategy(method, name);
        }
        return null;
    }

    public AttributeStrategy getFlowAttribute(QName name) throws Exception {
        return TypeStrategyFactory.getFlowAttribute(this.getType(), name);
    }

    public AttributeStrategy getEnvironmentAttribute(QName name) throws Exception {
        return null;
    }

    @Override
    public void init(Object bean) throws Exception {
        if (this._init != null) {
            this._init.invoke(bean, new Object[0]);
        }
    }

    @Override
    public Object replaceObject(Object bean) throws Exception {
        if (this._replaceObject != null) {
            return this._replaceObject.invoke(bean, new Object[0]);
        }
        return bean;
    }

    protected Method findOneArgSetter(String attributeName) {
        String methodSuffix = BeanTypeStrategy.attributeNameToBeanName(attributeName);
        Method method = this.findSetter(new CharBuffer().append("set").append(methodSuffix).toString());
        if (method == null) {
            method = this.findSetter(new CharBuffer().append("add").append(methodSuffix).toString());
        }
        return method;
    }

    protected Method findCreate(String attributeName) {
        String methodSuffix = BeanTypeStrategy.attributeNameToBeanName(attributeName);
        return this.findMethod(new CharBuffer().append("create").append(methodSuffix).toString(), new Class[0]);
    }

    protected Method findSetter(String methodName) {
        Method method = this.findSetter(methodName, false);
        if (method != null) {
            return method;
        }
        return this.findSetter(methodName, true);
    }

    protected Method findSetter(String methodName, boolean ignoreCase) {
        Method bestMethod = null;
        Method[] methods = this.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!ignoreCase && !method.getName().equals(methodName) || ignoreCase && !method.getName().equalsIgnoreCase(methodName) || method.getParameterTypes().length != 1) continue;
            if (method.getParameterTypes()[0].equals(BeanTypeStrategy._resin_compat_class_0())) {
                return method;
            }
            bestMethod = method;
        }
        return bestMethod;
    }

    protected static String attributeNameToBeanName(String name) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '-') {
                cb.append(Character.toUpperCase(name.charAt(++i)));
                continue;
            }
            if (ch == ':') {
                cb.clear();
                continue;
            }
            cb.append(ch);
        }
        if (Character.isLowerCase(cb.charAt(0))) {
            cb.setCharAt(0, Character.toUpperCase(cb.charAt(0)));
        }
        return cb.close();
    }

    protected Method findSetPropertyMethod() {
        Method method = this.findSetPropertyMethod("setProperty");
        if (method != null) {
            return method;
        }
        method = this.findSetPropertyMethod("setAttribute");
        if (method != null) {
            return method;
        }
        method = this.findSetPropertyMethod("put");
        if (method != null) {
            return method;
        }
        method = this.findSetPropertyMethod("set");
        if (method != null) {
            return method;
        }
        return method;
    }

    protected Method findSetPropertyMethod(String methodName) {
        Method method = this.findSetPropertyMethod(methodName, BeanTypeStrategy._resin_compat_class_0(), BeanTypeStrategy._resin_compat_class_4());
        if (method != null) {
            return method;
        }
        method = this.findSetPropertyMethod(methodName, BeanTypeStrategy._resin_compat_class_5(), BeanTypeStrategy._resin_compat_class_4());
        if (method != null) {
            return method;
        }
        method = this.findSetPropertyMethod(methodName, BeanTypeStrategy._resin_compat_class_3(), null);
        if (method != null) {
            return method;
        }
        method = this.findSetPropertyMethod(methodName, BeanTypeStrategy._resin_compat_class_0(), BeanTypeStrategy._resin_compat_class_0());
        if (method != null) {
            return method;
        }
        method = this.findSetPropertyMethod(methodName, BeanTypeStrategy._resin_compat_class_0(), BeanTypeStrategy._resin_compat_class_5());
        if (method != null) {
            return method;
        }
        method = this.findSetPropertyMethod(methodName, BeanTypeStrategy._resin_compat_class_0(), null);
        if (method != null) {
            return method;
        }
        method = this.findSetPropertyMethod(methodName, BeanTypeStrategy._resin_compat_class_5(), BeanTypeStrategy._resin_compat_class_5());
        if (method != null) {
            return method;
        }
        method = this.findSetPropertyMethod(methodName, BeanTypeStrategy._resin_compat_class_5(), null);
        if (method != null) {
            return method;
        }
        return null;
    }

    protected Method findSetPropertyMethod(String name, Class keyClass, Class valueClass) {
        Method[] methods = this.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] methodTypes;
            Method method = methods[i];
            if (!method.getName().equals(name) || !Modifier.isPublic(method.getModifiers()) || (methodTypes = method.getParameterTypes()).length != 2 || !methodTypes[0].equals(keyClass) || valueClass != null && !methodTypes[1].equals(valueClass)) continue;
            return method;
        }
        return null;
    }

    protected Method findProgramBuilderMethod() {
        Method method = this.findMethod("addBuilderProgram", new Class[]{BeanTypeStrategy._resin_compat_class_4()});
        if (method != null) {
            return method;
        }
        return method;
    }

    protected Method findMethod(String methodName, Class[] parameterTypes) {
        Method[] methods = this.getMethods();
        block0: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] methodTypes;
            Method method = methods[i];
            if (!method.getName().equals(methodName) || !Modifier.isPublic(method.getModifiers()) || (methodTypes = method.getParameterTypes()).length != parameterTypes.length) continue;
            for (int j = 0; j < methodTypes.length; ++j) {
                if (parameterTypes[j] != null && !methodTypes[j].equals(parameterTypes[j])) continue block0;
            }
            return method;
        }
        return null;
    }

    private Method[] getMethods() {
        Method[] methods;
        SoftReference<Method[]> methodsRef = this._methodsRef;
        if (methodsRef != null && (methods = methodsRef.get()) != null) {
            return methods;
        }
        ArrayList<Method> methodList = new ArrayList<Method>();
        BeanTypeStrategy.getMethods(methodList, this._type);
        methods = methodList.toArray(new Method[methodList.size()]);
        this._methodsRef = new SoftReference<Method[]>(methods);
        return methods;
    }

    public static void getMethods(ArrayList<Method> list, Class type) {
        int i;
        if (type == null) {
            return;
        }
        if (Modifier.isPublic(type.getModifiers())) {
            Method[] methods = type.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                if (BeanTypeStrategy.contains(list, methods[i])) continue;
                list.add(methods[i]);
            }
        }
        Class<?>[] interfaces = type.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            BeanTypeStrategy.getMethods(list, interfaces[i]);
        }
        BeanTypeStrategy.getMethods(list, type.getSuperclass());
    }

    public static boolean contains(ArrayList<Method> list, Method method) {
        for (int i = 0; i < list.size(); ++i) {
            if (!BeanTypeStrategy.isMatch(list.get(i), method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatch(Method methodA, Method methodB) {
        Class<?>[] paramB;
        if (!methodA.getName().equals(methodB.getName())) {
            return false;
        }
        Class<?>[] paramA = methodA.getParameterTypes();
        if (paramA.length != (paramB = methodB.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < paramA.length; ++i) {
            if (paramA[i].equals(paramB[i])) continue;
            return false;
        }
        return true;
    }

    protected static void invokeBeanMethod(Object bean, Method method, Object[] args) throws ConfigException {
        try {
            method.invoke(bean, args);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(L.l("{0}: parameter type mismatch invoking method `{1}'.", (Object)bean.getClass().getName(), method.toString()), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigException(L.l("Bean method `{0}' isn't accessible.", method.toString()), e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigException(e.getCause());
        }
    }

    protected VariableResolver getEnvironment() {
        return Config.getEnvironment();
    }

    protected static NotImplementedException notImplemented() {
        return new NotImplementedException(L.l("Not implemented."));
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.make.PersistentDependency");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("org.w3c.dom.Node");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("com.caucho.xml.QName");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("com.caucho.config.BuilderProgram");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("java.lang.Object");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_6() {
        try {
            Class<?> clazz = _resin_compat_class_6;
            if (clazz == null) {
                clazz = _resin_compat_class_6 = Class.forName("com.caucho.config.BeanTypeStrategy");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

