/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode.compat;

import com.caucho.bytecode.Analyzer;
import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.ClassConstant;
import com.caucho.bytecode.CodeAttribute;
import com.caucho.bytecode.CodeEnhancer;
import com.caucho.bytecode.CodeVisitor;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.bytecode.FieldRefConstant;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaField;
import com.caucho.bytecode.JavaMethod;
import com.caucho.bytecode.MethodRefConstant;
import com.caucho.bytecode.OpaqueAttribute;
import com.caucho.bytecode.StringConstant;
import com.caucho.bytecode.Utf8Constant;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.util.Log;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class Jdk15Compat {
    private static final Logger log = Log.open(Jdk15Compat._resin_compat_class_0());
    private static final HashMap<String, String> _boxedClasses = new HashMap();
    public static final int MAJOR_1_5 = 49;
    public static final int MAJOR_1_4 = 48;
    private JavaClass _jClass;
    private ConstantPool _jPool;
    private ArrayList<String> _classes = new ArrayList();
    private static String STRING_BUILDER = "java*lang*StringBuilder".replace('*', '/');
    private static Class _resin_compat_class_0;

    public static void main(String[] args) throws Exception {
        String[] arr$ = args;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String pathName = arr$[i$];
            Path path = Vfs.lookup(pathName);
            Jdk15Compat.convert(path);
        }
    }

    private static void convert(Path path) throws Exception {
        if (path.isDirectory()) {
            String[] arr$ = path.list();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String name = arr$[i$];
                Jdk15Compat.convert(path.lookup(name));
            }
        } else if (path.getPath().endsWith(".class")) {
            new Jdk15Compat().convertFile(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertFile(Path path) throws Exception {
        JavaClass jClass = null;
        ReadStream is = path.openRead();
        try {
            jClass = new ByteCodeParser().parse(is);
        }
        finally {
            is.close();
        }
        this._jClass = jClass;
        this._jPool = jClass.getConstantPool();
        if (jClass.getMajor() < 49) {
            return;
        }
        jClass.setMajor(48);
        try {
            ArrayList<ConstantPoolEntry> entries = new ArrayList<ConstantPoolEntry>();
            entries.addAll(jClass.getConstantPool().getEntries());
            Iterator<Object> i$ = entries.iterator();
            while (i$.hasNext()) {
                ConstantPoolEntry entry = (ConstantPoolEntry)i$.next();
                if (entry instanceof Utf8Constant) {
                    Utf8Constant utf8 = (Utf8Constant)entry;
                    String value = utf8.getValue();
                    value = this.convertStringBuilder(value);
                    utf8.setValue(value);
                    continue;
                }
                if (!(entry instanceof MethodRefConstant)) continue;
                MethodRefConstant method = (MethodRefConstant)entry;
                this.convertMethodName(jClass.getConstantPool(), method);
            }
            i$ = jClass.getFieldList().iterator();
            while (i$.hasNext()) {
                JavaField jField = (JavaField)i$.next();
                jField.setDescriptor(this.convertStringBuilder(jField.getDescriptor()));
                this.convertField(jClass, jField);
            }
            i$ = jClass.getMethodList().iterator();
            while (i$.hasNext()) {
                JavaMethod jMethod = (JavaMethod)i$.next();
                jMethod.setDescriptor(this.convertStringBuilder(jMethod.getDescriptor()));
                this.convertMethod(jClass, jMethod);
            }
            for (int i = 0; i < this._classes.size(); ++i) {
                this.addClassForName(this._classes.get(i));
            }
            System.out.println(new CharBuffer().append("COMPLETE: ").append(jClass).toString());
            WriteStream os = path.openWrite();
            try {
                jClass.write(os);
            }
            finally {
                os.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private String convertStringBuilder(String value) {
        while (value.indexOf(STRING_BUILDER) >= 0) {
            value = value.replace(STRING_BUILDER, "com/caucho/util/CharBuffer");
        }
        return value;
    }

    private void convertMethodName(ConstantPool cp, MethodRefConstant call) {
        if (!call.getName().equals("valueOf")) {
            return;
        }
        String shortName = _boxedClasses.get(call.getClassName());
        if (shortName == null) {
            return;
        }
        if (call.getType().indexOf("String") >= 0) {
            return;
        }
        String className = call.getClassName();
        ClassConstant jClass = cp.addClass("com/caucho/bytecode/compat/Box");
        call.setClassIndex(jClass.getIndex());
        call.setNameAndType(new CharBuffer().append("box").append(shortName).toString(), call.getType());
    }

    private void convertMethod(JavaClass jClass, JavaMethod jMethod) throws Exception {
        CodeAttribute jCode = jMethod.getCode();
        if (jCode == null) {
            return;
        }
        ArrayList<Attribute> attrList = jCode.getAttributes();
        for (int i = attrList.size() - 1; i >= 0; --i) {
            Attribute attr = attrList.get(i);
            if (attr.getName().equals("LocalVariableTable")) {
                this.convertLocalVariableTable((OpaqueAttribute)attr);
                continue;
            }
            if (!attr.getName().equals("LocalVariableTypeTable")) continue;
            attrList.remove(i);
        }
        jCode.setAttributes(attrList);
        CompatAnalyzer analyzer = new CompatAnalyzer();
        CodeEnhancer visitor = new CodeEnhancer(jClass, jCode);
        visitor.analyze(analyzer, true);
        visitor.update();
    }

    private void convertField(JavaClass jClass, JavaField jField) throws Exception {
    }

    private void convertVariableTypeTable(OpaqueAttribute attr) throws Exception {
        byte[] data = attr.getValue();
        int offset = 0;
        int len = this.readShort(data, offset);
        offset += 2;
        for (int i = 0; i < len; ++i) {
            int index = this.readShort(data, offset + 6);
            String descriptor = this._jPool.getUtf8AsString(index);
            String newValue = this.convertDescriptor(descriptor);
            Utf8Constant newDescriptor = this._jPool.addUTF8(newValue);
            this.writeShort(data, offset + 6, newDescriptor.getIndex());
            offset += 10;
        }
    }

    private void convertLocalVariableTable(OpaqueAttribute attr) throws Exception {
        byte[] data = attr.getValue();
        int offset = 0;
        int len = this.readShort(data, offset);
        offset += 2;
        for (int i = 0; i < len; ++i) {
            int index = this.readShort(data, offset + 6);
            String descriptor = this._jPool.getUtf8AsString(index);
            String newValue = this.convertDescriptor(descriptor);
            Utf8Constant newDescriptor = this._jPool.addUTF8(newValue);
            this.writeShort(data, offset + 6, newDescriptor.getIndex());
            offset += 10;
        }
    }

    private void addClassForName(String className) {
        int classIndex = this._classes.indexOf(className);
        if (classIndex < 0) {
            throw new IllegalStateException();
        }
        ByteBuffer bb = new ByteBuffer();
        String fieldName = new CharBuffer().append("_resin_compat_class_").append(classIndex).toString();
        String methodName = new CharBuffer().append("_resin_compat_class_").append(classIndex).toString();
        if (this._jClass.isInterface()) {
            throw new IllegalStateException(new CharBuffer().append(this._jClass).append(" is an interface.  It can't have .class references.").toString());
        }
        JavaField field = new JavaField();
        field.setJavaClass(this._jClass);
        field.setName(fieldName);
        field.setDescriptor("Ljava/lang/Class;");
        field.setAccessFlags(10);
        this._jClass.addField(field);
        StringConstant classNameConst = this._jPool.addString(className.replace('/', '.'));
        FieldRefConstant fieldRefConst = this._jPool.addFieldRef(this._jClass.getName().replace('.', '/'), fieldName, "Ljava/lang/Class;");
        MethodRefConstant forNameConst = this._jPool.addMethodRef("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        bb.addByte(178);
        bb.addShort(fieldRefConst.getIndex());
        bb.addByte(89);
        bb.addByte(199);
        bb.addShort(14);
        bb.addByte(87);
        bb.addByte(19);
        bb.addShort(classNameConst.getIndex());
        bb.addByte(184);
        bb.addShort(forNameConst.getIndex());
        bb.addByte(89);
        bb.addByte(179);
        bb.addShort(fieldRefConst.getIndex());
        bb.addByte(176);
        int end = bb.getLength();
        bb.addByte(1);
        bb.addByte(176);
        CodeAttribute code = new CodeAttribute();
        byte[] codeBuffer = new byte[bb.getLength()];
        System.arraycopy(bb.getBuffer(), 0, codeBuffer, 0, bb.getLength());
        code.setCode(codeBuffer);
        code.setMaxLocals(0);
        code.setMaxStack(2);
        code.addException(this._jPool.addClass("java/lang/ClassNotFoundException"), 0, end, end);
        String descriptor = "()Ljava/lang/Class;";
        this._jPool.addUTF8(methodName);
        this._jPool.addUTF8("Code");
        this._jPool.addUTF8(descriptor);
        JavaMethod method = new JavaMethod();
        method.setJavaClass(this._jClass);
        method.setName(methodName);
        method.setDescriptor(descriptor);
        method.setAccessFlags(10);
        method.addAttribute(code);
        this._jClass.addMethod(method);
    }

    private String convertDescriptor(String descriptor) {
        CharBuffer sb = new CharBuffer();
        this.convertDescriptor(sb, descriptor, 0);
        return sb.toString();
    }

    private int convertDescriptor(CharBuffer sb, String descriptor, int index) {
        int length = descriptor.length();
        block4: while (index < length) {
            char ch = descriptor.charAt(index);
            switch (ch) {
                case '<': {
                    index = this.convertDescriptor(null, descriptor, index + 1);
                    continue block4;
                }
                case '>': {
                    return index + 1;
                }
            }
            if (sb != null) {
                sb.append(ch);
            }
            ++index;
        }
        return index;
    }

    private int readShort(byte[] data, int offset) {
        return ((data[offset] & 0xFF) << 8) + (data[offset + 1] & 0xFF);
    }

    private void writeShort(byte[] data, int offset, int value) {
        data[offset + 0] = (byte)(value >> 8);
        data[offset + 1] = (byte)value;
    }

    static {
        _boxedClasses.put("java/lang/Boolean", "Boolean");
        _boxedClasses.put("java/lang/Byte", "Byte");
        _boxedClasses.put("java/lang/Short", "Short");
        _boxedClasses.put("java/lang/Integer", "Integer");
        _boxedClasses.put("java/lang/Long", "Long");
        _boxedClasses.put("java/lang/Float", "Float");
        _boxedClasses.put("java/lang/Double", "Double");
        _boxedClasses.put("java/lang/Character", "Character");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.compat.Jdk15Compat");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public class CompatAnalyzer
    extends Analyzer {
        public void analyze(CodeVisitor visitor) throws Exception {
            CodeEnhancer enhancer = (CodeEnhancer)visitor;
            int op = visitor.getOpcode();
            switch (op) {
                case 19: {
                    ConstantPoolEntry entry = Jdk15Compat.this._jPool.getEntry(visitor.getShortArg(1));
                    if (!(entry instanceof ClassConstant)) break;
                    ClassConstant classEntry = (ClassConstant)entry;
                    int offset = enhancer.getOffset();
                    enhancer.remove(offset, 3);
                    this.addClassGetter(enhancer, offset, classEntry.getName());
                    break;
                }
                case 18: {
                    ConstantPoolEntry entry = Jdk15Compat.this._jPool.getEntry(visitor.getByteArg(1));
                    if (!(entry instanceof ClassConstant)) break;
                    ClassConstant classEntry = (ClassConstant)entry;
                    int offset = enhancer.getOffset();
                    enhancer.remove(offset, 2);
                    this.addClassGetter(enhancer, offset, classEntry.getName());
                    break;
                }
            }
        }

        private void addClassGetter(CodeEnhancer enhancer, int offset, String className) {
            int classIndex = Jdk15Compat.this._classes.indexOf(className);
            if (classIndex < 0) {
                Jdk15Compat.this._classes.add(className);
                classIndex = Jdk15Compat.this._classes.size() - 1;
            }
            String methodName = new CharBuffer().append("_resin_compat_class_").append(classIndex).toString();
            StringConstant classNameConst = Jdk15Compat.this._jPool.addString(className);
            MethodRefConstant forNameConst = Jdk15Compat.this._jPool.addMethodRef(Jdk15Compat.this._jClass.getName().replace('.', '/'), methodName, "()Ljava/lang/Class;");
            enhancer.addNulls(offset, 3);
            enhancer.setByte(offset + 0, 184);
            enhancer.setShort(offset + 1, forNameConst.getIndex());
            enhancer.setOffset(offset);
        }
    }
}

