/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.JavaClass;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.util.logging.Logger;

public class SignatureAttribute
extends Attribute {
    private static final Logger log = Log.open(SignatureAttribute._resin_compat_class_0());
    private String _signature;
    private static Class _resin_compat_class_0;

    SignatureAttribute() {
        super("Signature");
    }

    SignatureAttribute(String signature) {
        super("Signature");
        this._signature = signature;
    }

    public String getSignature() {
        return this._signature;
    }

    public void read(ByteCodeParser in) throws IOException {
        int length = in.readInt();
        if (length != 2) {
            throw new IOException(new CharBuffer().append("expected length of 2 at ").append(length).toString());
        }
        int code = in.readShort();
        this._signature = in.getUTF8(code);
    }

    public void write(ByteCodeWriter out) throws IOException {
        out.writeUTF8Const(this.getName());
        out.writeInt(2);
        out.writeUTF8Const(this._signature);
    }

    public Attribute export(JavaClass source, JavaClass target) {
        ConstantPool cp = target.getConstantPool();
        cp.addUTF8(this.getName());
        cp.addUTF8(this._signature);
        return new SignatureAttribute(this._signature);
    }

    public String toString() {
        return new CharBuffer().append("SignatureAttribute[").append(this._signature).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.SignatureAttribute");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

