/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.JAnnotation;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JType;
import com.caucho.bytecode.JavaAnnotation;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaClassLoader;
import com.caucho.bytecode.OpaqueAttribute;
import com.caucho.bytecode.SignatureAttribute;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaField
extends JField {
    private static final Logger log = Log.open(JavaField._resin_compat_class_0());
    private JavaClass _jClass;
    private int _accessFlags;
    private String _name;
    private String _descriptor;
    private ArrayList<Attribute> _attributes = new ArrayList();
    private JavaAnnotation[] _annotations;
    private static Class _resin_compat_class_0;

    public void setJavaClass(JavaClass jClass) {
        this._jClass = jClass;
    }

    public JClass getDeclaringClass() {
        return this._jClass;
    }

    public JavaClassLoader getClassLoader() {
        return this._jClass.getClassLoader();
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setAccessFlags(int flags) {
        this._accessFlags = flags;
    }

    public int getAccessFlags() {
        return this._accessFlags;
    }

    public void setDescriptor(String descriptor) {
        this._descriptor = descriptor;
        if (this._jClass != null) {
            this._jClass.getConstantPool().addUTF8(descriptor);
        }
    }

    public String getDescriptor() {
        return this._descriptor;
    }

    public JClass getType() {
        return this.getClassLoader().descriptorToClass(this.getDescriptor(), 0);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getAccessFlags());
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.getAccessFlags());
    }

    public JType getGenericType() {
        SignatureAttribute sigAttr = (SignatureAttribute)this.getAttribute("Signature");
        if (sigAttr != null) {
            return this.getClassLoader().parseParameterizedType(sigAttr.getSignature());
        }
        return this.getType();
    }

    public void addAttribute(Attribute attr) {
        this._attributes.add(attr);
    }

    public Attribute getAttribute(String name) {
        for (int i = this._attributes.size() - 1; i >= 0; --i) {
            Attribute attr = this._attributes.get(i);
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public JAnnotation[] getDeclaredAnnotations() {
        if (this._annotations == null) {
            Attribute attr = this.getAttribute("RuntimeVisibleAnnotations");
            if (attr instanceof OpaqueAttribute) {
                byte[] buffer = ((OpaqueAttribute)attr).getValue();
                try {
                    ByteArrayInputStream is = new ByteArrayInputStream(buffer);
                    ConstantPool cp = this._jClass.getConstantPool();
                    this._annotations = JavaAnnotation.parseAnnotations(is, cp, this.getClassLoader());
                }
                catch (IOException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            if (this._annotations == null) {
                this._annotations = new JavaAnnotation[0];
            }
        }
        return this._annotations;
    }

    public void write(ByteCodeWriter out) throws IOException {
        out.writeShort(this._accessFlags);
        out.writeUTF8Const(this._name);
        out.writeUTF8Const(this._descriptor);
        out.writeShort(this._attributes.size());
        for (int i = 0; i < this._attributes.size(); ++i) {
            Attribute attr = this._attributes.get(i);
            attr.write(out);
        }
    }

    public JavaField export(JavaClass cl, JavaClass target) {
        JavaField field = new JavaField();
        field.setName(this._name);
        field.setDescriptor(this._descriptor);
        field.setAccessFlags(this._accessFlags);
        target.getConstantPool().addUTF8(this._name);
        target.getConstantPool().addUTF8(this._descriptor);
        for (int i = 0; i < this._attributes.size(); ++i) {
            Attribute attr = this._attributes.get(i);
            field.addAttribute(attr.export(cl, target));
        }
        return field;
    }

    public boolean equals(Object o) {
        if (o == null || !JavaField._resin_compat_class_0().equals(o.getClass())) {
            return false;
        }
        JavaField field = (JavaField)o;
        return this._name.equals(field._name);
    }

    public String toString() {
        return new CharBuffer().append("JavaField[").append(this._name).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.JavaField");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

