/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.JAnnotation;
import com.caucho.bytecode.JavaClassLoader;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAnnotation
extends JAnnotation {
    private static final Logger log = Logger.getLogger(JavaAnnotation._resin_compat_class_0().getName());
    private static Method _enumValueOf;
    private JavaClassLoader _loader;
    private HashMap<String, Object> _valueMap = new HashMap(8);
    private String _type;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;

    public void setClassLoader(JavaClassLoader loader) {
        this._loader = loader;
    }

    public JavaClassLoader getClassLoader() {
        return this._loader;
    }

    public void setType(String type) {
        this._type = type;
    }

    @Override
    public String getType() {
        return this._type;
    }

    public HashMap<String, Object> getValueMap() {
        return this._valueMap;
    }

    public Object putValue(String key, Object value) {
        return this._valueMap.put(key, value);
    }

    static JavaAnnotation[] parseAnnotations(InputStream is, ConstantPool cp, JavaClassLoader loader) throws IOException {
        int n = JavaAnnotation.readShort(is);
        JavaAnnotation[] annArray = new JavaAnnotation[n];
        for (int i = 0; i < n; ++i) {
            annArray[i] = JavaAnnotation.parseAnnotation(is, cp, loader);
        }
        return annArray;
    }

    private static JavaAnnotation parseAnnotation(InputStream is, ConstantPool cp, JavaClassLoader loader) throws IOException {
        JavaAnnotation ann = new JavaAnnotation();
        ann.setClassLoader(loader);
        int type = JavaAnnotation.readShort(is);
        String typeName = cp.getUtf8(type).getValue();
        if (typeName.endsWith(";")) {
            typeName = typeName.substring(1, typeName.length() - 1).replace('/', '.');
        }
        ann.setType(typeName);
        try {
            Class<?> aClass = Class.forName(typeName, false, Thread.currentThread().getContextClassLoader());
            for (Method method : aClass.getDeclaredMethods()) {
                Object value = method.getDefaultValue();
                if (value == null) continue;
                ann.putValue(method.getName(), value);
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        int nPairs = JavaAnnotation.readShort(is);
        for (int j = 0; j < nPairs; ++j) {
            int nameIndex = JavaAnnotation.readShort(is);
            String name = cp.getUtf8(nameIndex).getValue();
            Object value = JavaAnnotation.parseElementValue(is, cp, loader);
            ann.putValue(name, value);
        }
        return ann;
    }

    private static Object parseElementValue(InputStream is, ConstantPool cp, JavaClassLoader loader) throws IOException {
        int tag = is.read();
        switch (tag) {
            case 90: {
                int i = JavaAnnotation.readShort(is);
                return cp.getInteger(i).getValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 66: {
                int i = JavaAnnotation.readShort(is);
                return new Byte((byte)cp.getInteger(i).getValue());
            }
            case 83: {
                int i = JavaAnnotation.readShort(is);
                return new Short((short)cp.getInteger(i).getValue());
            }
            case 73: {
                int i = JavaAnnotation.readShort(is);
                return new Integer(cp.getInteger(i).getValue());
            }
            case 74: {
                int i = JavaAnnotation.readShort(is);
                return new Long(cp.getLong(i).getValue());
            }
            case 70: {
                int i = JavaAnnotation.readShort(is);
                return new Float(cp.getFloat(i).getValue());
            }
            case 68: {
                int i = JavaAnnotation.readShort(is);
                return new Double(cp.getDouble(i).getValue());
            }
            case 67: {
                int i = JavaAnnotation.readShort(is);
                return new Character((char)cp.getInteger(i).getValue());
            }
            case 115: {
                int i = JavaAnnotation.readShort(is);
                return cp.getUtf8(i).getValue();
            }
            case 101: {
                int type = JavaAnnotation.readShort(is);
                int value = JavaAnnotation.readShort(is);
                String enumClassName = cp.getUtf8(type).getValue();
                enumClassName = enumClassName.substring(1, enumClassName.length() - 1);
                enumClassName = enumClassName.replace('/', '.');
                try {
                    Class<?> enumClass = Class.forName(enumClassName, false, Thread.currentThread().getContextClassLoader());
                    String enumName = cp.getUtf8(value).getValue();
                    return _enumValueOf.invoke(null, enumClass, enumName);
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                    return null;
                }
            }
            case 99: {
                return cp.getUtf8(JavaAnnotation.readShort(is)).getValue();
            }
            case 64: {
                return JavaAnnotation.parseAnnotation(is, cp, loader);
            }
            case 91: {
                int n = JavaAnnotation.readShort(is);
                Object[] array = new Object[n];
                for (int j = 0; j < n; ++j) {
                    array[j] = JavaAnnotation.parseElementValue(is, cp, loader);
                }
                return array;
            }
        }
        throw new IllegalStateException();
    }

    static int readShort(InputStream is) throws IOException {
        return ((is.read() & 0xFF) << 8) + (is.read() & 0xFF);
    }

    static int readInt(InputStream is) throws IOException {
        return ((is.read() & 0xFF) << 24) + ((is.read() & 0xFF) << 16) + ((is.read() & 0xFF) << 8) + (is.read() & 0xFF);
    }

    @Override
    public String toString() {
        return new CharBuffer().append("JavaAnnotation[").append(this._type).append("]").toString();
    }

    static {
        try {
            Class<?> cl = Class.forName("java.lang.Enum");
            _enumValueOf = cl.getMethod("valueOf", JavaAnnotation._resin_compat_class_1(), JavaAnnotation._resin_compat_class_2());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.JavaAnnotation");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.lang.Class");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

