/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JType;
import com.caucho.util.CharBuffer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class JTypeWrapper
implements JType {
    private JClassLoader _loader;
    private ParameterizedType _type;

    public JTypeWrapper(JClassLoader loader, ParameterizedType type) {
        this._loader = loader;
        this._type = type;
    }

    public String getName() {
        return ((Class)this._type.getRawType()).getName();
    }

    public String getPrintName() {
        JType[] typeArgs = this.getActualTypeArguments();
        if (typeArgs.length == 0) {
            return this.getRawClass().getPrintName();
        }
        CharBuffer cb = new CharBuffer();
        cb.append(this.getRawClass().getPrintName());
        cb.append('<');
        for (int i = 0; i < typeArgs.length; ++i) {
            if (i != 0) {
                cb.append(',');
            }
            cb.append(typeArgs[i].getPrintName());
        }
        cb.append('>');
        return cb.toString();
    }

    public JType[] getActualTypeArguments() {
        Type[] rawArgs = this._type.getActualTypeArguments();
        JType[] args = new JType[rawArgs.length];
        for (int i = 0; i < args.length; ++i) {
            Type type = rawArgs[i];
            if (type instanceof Class) {
                args[i] = this._loader.forName(((Class)type).getName());
                continue;
            }
            if (type instanceof ParameterizedType) {
                args[i] = new JTypeWrapper(this._loader, (ParameterizedType)type);
                continue;
            }
            throw new IllegalStateException(type.toString());
        }
        return args;
    }

    public JClass getRawType() {
        return this._loader.forName(((Class)this._type.getRawType()).getName());
    }

    public boolean isPrimitive() {
        return this.getRawClass().isPrimitive();
    }

    public boolean isPublic() {
        return this.getRawClass().isPublic();
    }

    public boolean isAbstract() {
        return this.getRawClass().isAbstract();
    }

    public boolean isFinal() {
        return this.getRawClass().isFinal();
    }

    public boolean isInterface() {
        return this.getRawClass().isAbstract();
    }

    public JClass getSuperClass() {
        return this.getRawClass().getSuperClass();
    }

    public JClass[] getInterfaces() {
        return this.getRawClass().getInterfaces();
    }

    public boolean isArray() {
        return this.getRawClass().isArray();
    }

    public JClass getComponentType() {
        return null;
    }

    public boolean isAssignableTo(Class cl) {
        return this.getRawClass().isAssignableTo(cl);
    }

    public boolean isAssignableFrom(Class cl) {
        return this.getRawClass().isAssignableFrom(cl);
    }

    public boolean isAssignableFrom(JClass cl) {
        return this.getRawClass().isAssignableFrom(cl);
    }

    public JMethod[] getDeclaredMethods() {
        return this.getRawClass().getDeclaredMethods();
    }

    public JMethod[] getMethods() {
        return this.getRawClass().getMethods();
    }

    public JMethod getMethod(String name, JClass[] param) {
        return this.getRawClass().getMethod(name, param);
    }

    public JField[] getDeclaredFields() {
        return this.getRawClass().getDeclaredFields();
    }

    public JField[] getFields() {
        return this.getRawClass().getFields();
    }

    private JClass getRawClass() {
        return this._loader.forName(((Class)this._type.getRawType()).getName());
    }
}

