/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JType;
import com.caucho.bytecode.JTypeWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class JFieldWrapper
extends JField {
    private JClassLoader _loader;
    private Field _field;

    public JFieldWrapper(Field field, JClassLoader loader) {
        this._loader = loader;
        this._field = field;
    }

    public String getName() {
        return this._field.getName();
    }

    public JClass getDeclaringClass() {
        return this._loader.forName(this._field.getDeclaringClass().getName());
    }

    public JClass getType() {
        return this._loader.forName(this._field.getType().getName());
    }

    public JType getGenericType() {
        try {
            Type type = this._field.getGenericType();
            if (type instanceof Class) {
                return this.getType();
            }
            return new JTypeWrapper(this._loader, (ParameterizedType)type);
        }
        catch (NoSuchMethodError e) {
            return this.getType();
        }
    }

    public boolean isStatic() {
        return Modifier.isStatic(this._field.getModifiers());
    }

    public boolean isTransient() {
        return Modifier.isTransient(this._field.getModifiers());
    }
}

