/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JConstructorWrapper;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JFieldWrapper;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JMethodWrapper;
import com.caucho.util.CharBuffer;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JClassWrapper
extends JClass {
    private JClassLoader _loader;
    private Class _class;
    private SoftReference<JMethod[]> _declaredMethodsRef;

    public JClassWrapper(Class cl, JClassLoader loader) {
        this._loader = loader;
        this._class = cl;
    }

    JClassWrapper(Class cl) {
        this._class = cl;
    }

    public String getName() {
        return this._class.getName();
    }

    public Class getJavaClass() {
        return this._class;
    }

    public Class getWrappedClass() {
        return this._class;
    }

    public JClassLoader getClassLoader() {
        if (this._loader != null) {
            return this._loader;
        }
        return JClassLoader.getSystemClassLoader();
    }

    public boolean isPrimitive() {
        return this._class.isPrimitive();
    }

    public boolean isArray() {
        return this._class.isArray();
    }

    public JClass getComponentType() {
        return this.getClassLoader().forName(this._class.getComponentType().getName());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this._class.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this._class.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this._class.getModifiers());
    }

    public boolean isInterface() {
        return this._class.isInterface();
    }

    public boolean isAssignableTo(Class cl) {
        return cl.isAssignableFrom(this._class);
    }

    public boolean isAssignableFrom(Class cl) {
        return this._class.isAssignableFrom(cl);
    }

    public boolean isAssignableFrom(JClass cl) {
        return cl.isAssignableTo(this._class);
    }

    public JClass getSuperClass() {
        Class cl = this._class.getSuperclass();
        if (cl != null) {
            return this._loader.forName(cl.getName());
        }
        return null;
    }

    public JClass[] getInterfaces() {
        Class<?>[] cl = this._class.getInterfaces();
        JClass[] clList = new JClass[cl.length];
        for (int i = 0; i < cl.length; ++i) {
            clList[i] = this._loader.forName(cl[i].getName());
        }
        return clList;
    }

    public JMethod[] getDeclaredMethods() {
        SoftReference<JMethod[]> jMethodsRef = this._declaredMethodsRef;
        JMethod[] jMethods = null;
        if (jMethodsRef != null && (jMethods = jMethodsRef.get()) != null) {
            return jMethods;
        }
        Method[] methods = this._class.getDeclaredMethods();
        jMethods = new JMethod[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            jMethods[i] = new JMethodWrapper(methods[i], this.getClassLoader());
        }
        this._declaredMethodsRef = new SoftReference<JMethod[]>(jMethods);
        return jMethods;
    }

    public JMethod[] getMethods() {
        Method[] methods = this._class.getMethods();
        JMethod[] jMethods = new JMethod[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            jMethods[i] = new JMethodWrapper(methods[i], this.getClassLoader());
        }
        return jMethods;
    }

    public JMethod getMethod(String name, JClass[] types) {
        JClassLoader jClassLoader = this.getClassLoader();
        return JClassWrapper.getMethod(this._class, name, types, jClassLoader);
    }

    private static JMethod getMethod(Class cl, String name, JClass[] types, JClassLoader jClassLoader) {
        int i$;
        if (cl == null) {
            return null;
        }
        GenericDeclaration[] arr$ = cl.getDeclaredMethods();
        int len$ = arr$.length;
        block0: for (i$ = 0; i$ < len$; ++i$) {
            Class<?>[] paramTypes;
            Method method = arr$[i$];
            if (!method.getName().equals(name) || types.length != (paramTypes = method.getParameterTypes()).length) continue;
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].getName().equals(paramTypes[i].getName())) continue block0;
            }
            return new JMethodWrapper(method, jClassLoader);
        }
        arr$ = cl.getInterfaces();
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            GenericDeclaration ifc = arr$[i$];
            JMethod method = JClassWrapper.getMethod((Class)ifc, name, types, jClassLoader);
            if (method == null) continue;
            return method;
        }
        return JClassWrapper.getMethod(cl.getSuperclass(), name, types, jClassLoader);
    }

    public JMethod[] getConstructors() {
        Constructor<?>[] methods = this._class.getConstructors();
        JMethod[] jMethods = new JMethod[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            jMethods[i] = new JConstructorWrapper(methods[i], this.getClassLoader());
        }
        return jMethods;
    }

    public JField[] getDeclaredFields() {
        Field[] fields = this._class.getDeclaredFields();
        JField[] jFields = new JField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            jFields[i] = new JFieldWrapper(fields[i], this.getClassLoader());
        }
        return jFields;
    }

    public JField[] getFields() {
        Field[] fields = this._class.getFields();
        JField[] jFields = new JField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            jFields[i] = new JFieldWrapper(fields[i], this.getClassLoader());
        }
        return jFields;
    }

    public String toString() {
        return new CharBuffer().append("JClassWrapper[").append(this.getName()).append("]").toString();
    }
}

