/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JClassWrapper;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.CharBuffer;
import java.util.logging.Level;

public class JClassLoaderWrapper
extends JClassLoader {
    private static final EnvironmentLocal<JClassLoaderWrapper> _localClassLoader = new EnvironmentLocal();
    private ClassLoader _loader;

    private JClassLoaderWrapper(ClassLoader loader) {
        this._loader = loader;
    }

    public static JClassLoaderWrapper create() {
        return JClassLoaderWrapper.create(Thread.currentThread().getContextClassLoader());
    }

    public static JClassLoaderWrapper create(ClassLoader loader) {
        JClassLoaderWrapper jLoader = _localClassLoader.getLevel(loader);
        if (jLoader == null) {
            jLoader = new JClassLoaderWrapper(loader);
            _localClassLoader.set(jLoader, loader);
        }
        return jLoader;
    }

    protected JClass loadClass(String name) {
        try {
            Class<?> cl = this._loader != null ? Class.forName(name, false, this._loader) : Class.forName(name);
            return new JClassWrapper(cl, this);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public String toString() {
        return new CharBuffer().append("JClassLoaderWrapper[").append(this._loader).append("]").toString();
    }
}

