/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.util.CharBuffer;

public class JClassArray
extends JClass {
    private JClass _componentType;

    JClassArray(JClass component) {
        if (component == null) {
            throw new NullPointerException();
        }
        this._componentType = component;
    }

    public String getName() {
        return new CharBuffer().append("[").append(this._componentType.getName()).toString();
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isPublic() {
        return true;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isFinal() {
        return true;
    }

    public boolean isInterface() {
        return false;
    }

    public JClass getSuperClass() {
        return JClass.OBJECT;
    }

    public JClass[] getInterfaces() {
        return new JClass[0];
    }

    public JMethod[] getConstructors() {
        return new JMethod[0];
    }

    public boolean isArray() {
        return true;
    }

    public JClass getComponentType() {
        return this._componentType;
    }

    public boolean isAssignableTo(Class cl) {
        return this.getName().equals(cl.getName());
    }

    public boolean isAssignableFrom(Class cl) {
        return this.getName().equals(cl.getName());
    }

    public boolean isAssignableFrom(JClass cl) {
        return this.getName().equals(cl.getName());
    }

    public JMethod[] getDeclaredMethods() {
        return new JMethod[0];
    }

    public JMethod[] getMethods() {
        return new JMethod[0];
    }

    public JMethod getMethod(String name, JClass[] param) {
        return null;
    }

    public JField[] getDeclaredFields() {
        return new JField[0];
    }

    public JField[] getFields() {
        return new JField[0];
    }

    public String getPrintName() {
        if (this.isArray()) {
            return new CharBuffer().append(this.getComponentType().getPrintName()).append("[]").toString();
        }
        return this.getName();
    }

    public String getShortName() {
        if (this.isArray()) {
            return new CharBuffer().append(this.getComponentType().getShortName()).append("[]").toString();
        }
        String name = this.getName();
        int p = name.lastIndexOf(46);
        if (p >= 0) {
            return name.substring(p + 1);
        }
        return name;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JClass jClass = (JClass)o;
        return this.getName().equals(jClass.getName());
    }

    public String toString() {
        return new CharBuffer().append("JClass[").append(this.getName()).append("]").toString();
    }
}

