/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.util.logging.Logger;

public class FloatConstant
extends ConstantPoolEntry {
    private static final Logger log = Log.open(FloatConstant._resin_compat_class_0());
    private float _value;
    private static Class _resin_compat_class_0;

    FloatConstant(ConstantPool pool, int index, float value) {
        super(pool, index);
        this._value = value;
    }

    public float getValue() {
        return this._value;
    }

    void write(ByteCodeWriter out) throws IOException {
        out.write(4);
        out.writeFloat(this._value);
    }

    public int export(ConstantPool target) {
        return target.addFloat(this._value).getIndex();
    }

    public String toString() {
        return new CharBuffer().append("FloatConstant[").append(this._value).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.FloatConstant");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

