/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.util.logging.Logger;

public class FieldRefConstant
extends ConstantPoolEntry {
    private static final Logger log = Log.open(FieldRefConstant._resin_compat_class_0());
    private int _classIndex;
    private int _nameAndTypeIndex;
    private static Class _resin_compat_class_0;

    FieldRefConstant(ConstantPool pool, int index, int classIndex, int nameAndTypeIndex) {
        super(pool, index);
        this._classIndex = classIndex;
        this._nameAndTypeIndex = nameAndTypeIndex;
    }

    public int getClassIndex() {
        return this._classIndex;
    }

    public void setClassIndex(int index) {
        this._classIndex = index;
    }

    public String getClassName() {
        return this.getConstantPool().getClass(this._classIndex).getName();
    }

    public String getName() {
        return this.getConstantPool().getNameAndType(this._nameAndTypeIndex).getName();
    }

    public String getType() {
        return this.getConstantPool().getNameAndType(this._nameAndTypeIndex).getType();
    }

    void write(ByteCodeWriter out) throws IOException {
        out.write(9);
        out.writeShort(this._classIndex);
        out.writeShort(this._nameAndTypeIndex);
    }

    public void setNameAndType(String name, String type) {
        this._nameAndTypeIndex = this.getConstantPool().addNameAndType(name, type).getIndex();
    }

    public int export(ConstantPool target) {
        return target.addFieldRef(this.getClassName(), this.getName(), this.getType()).getIndex();
    }

    public String toString() {
        return new CharBuffer().append("FieldRefConstant[").append(this.getClassName()).append(".").append(this.getName()).append("(").append(this.getType()).append(")]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.FieldRefConstant");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

