/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.JavaClass;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionsAttribute
extends Attribute {
    private static final Logger log = Log.open(ExceptionsAttribute._resin_compat_class_0());
    private ArrayList<String> _exceptions = new ArrayList();
    private static Class _resin_compat_class_0;

    ExceptionsAttribute(String name) {
        super(name);
    }

    public void addException(String exn) {
        this._exceptions.add(exn);
    }

    public ArrayList<String> getExceptionList() {
        return this._exceptions;
    }

    public void read(ByteCodeParser in) throws IOException {
        int length = in.readInt();
        int exnCount = in.readShort();
        for (int i = 0; i < exnCount; ++i) {
            int index = in.readShort();
            if (index == 0) {
                this._exceptions.add(null);
            }
            this._exceptions.add(in.getConstantPool().getClass(index).getName());
        }
    }

    @Override
    public void write(ByteCodeWriter out) throws IOException {
        out.writeUTF8Const(this.getName());
        TempStream ts = new TempStream();
        ts.openWrite();
        WriteStream ws = new WriteStream(ts);
        ByteCodeWriter o2 = new ByteCodeWriter(ws, out.getJavaClass());
        o2.writeShort(this._exceptions.size());
        for (int i = 0; i < this._exceptions.size(); ++i) {
            String exn = this._exceptions.get(i);
            o2.writeClass(exn);
        }
        ws.close();
        out.writeInt(ts.getLength());
        for (TempBuffer ptr = ts.getHead(); ptr != null; ptr = ptr.getNext()) {
            out.write(ptr.getBuffer(), 0, ptr.getLength());
        }
        ts.destroy();
    }

    @Override
    public Attribute export(JavaClass cl, JavaClass target) {
        ConstantPool cp = target.getConstantPool();
        cp.addUTF8(this.getName());
        ExceptionsAttribute attr = new ExceptionsAttribute(this.getName());
        for (int i = 0; i < this._exceptions.size(); ++i) {
            String exn = this._exceptions.get(i);
            cp.addClass(exn);
            attr.addException(exn);
        }
        return attr;
    }

    @Override
    public String toString() {
        return new CharBuffer().append("ExceptionsAttribute[").append(this.getName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.ExceptionsAttribute");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

