/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.util.logging.Logger;

public class DoubleConstant
extends ConstantPoolEntry {
    private static final Logger log = Log.open(DoubleConstant._resin_compat_class_0());
    private double _value;
    private static Class _resin_compat_class_0;

    DoubleConstant(ConstantPool pool, int index, double value) {
        super(pool, index);
        this._value = value;
    }

    public double getValue() {
        return this._value;
    }

    void write(ByteCodeWriter out) throws IOException {
        out.write(6);
        out.writeDouble(this._value);
    }

    public int export(ConstantPool target) {
        return target.addDouble(this._value).getIndex();
    }

    public String toString() {
        return new CharBuffer().append("DoubleConstant[").append(this._value).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.DoubleConstant");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

