/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ClassConstant;
import com.caucho.bytecode.CodeAttribute;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.bytecode.DoubleConstant;
import com.caucho.bytecode.ExceptionsAttribute;
import com.caucho.bytecode.FieldRefConstant;
import com.caucho.bytecode.FloatConstant;
import com.caucho.bytecode.IntegerConstant;
import com.caucho.bytecode.InterfaceMethodRefConstant;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaClassLoader;
import com.caucho.bytecode.JavaField;
import com.caucho.bytecode.JavaMethod;
import com.caucho.bytecode.LongConstant;
import com.caucho.bytecode.MethodRefConstant;
import com.caucho.bytecode.NameAndTypeConstant;
import com.caucho.bytecode.OpaqueAttribute;
import com.caucho.bytecode.SignatureAttribute;
import com.caucho.bytecode.StringConstant;
import com.caucho.bytecode.Utf8Constant;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ByteCodeParser {
    private static final Logger log = Log.open(ByteCodeParser._resin_compat_class_0());
    private static final L10N L = new L10N(ByteCodeParser._resin_compat_class_0());
    static final int CP_CLASS = 7;
    static final int CP_FIELD_REF = 9;
    static final int CP_METHOD_REF = 10;
    static final int CP_INTERFACE_METHOD_REF = 11;
    static final int CP_STRING = 8;
    static final int CP_INTEGER = 3;
    static final int CP_FLOAT = 4;
    static final int CP_LONG = 5;
    static final int CP_DOUBLE = 6;
    static final int CP_NAME_AND_TYPE = 12;
    static final int CP_UTF8 = 1;
    private JavaClassLoader _loader;
    private InputStream _is;
    private JavaClass _class;
    private ConstantPool _cp;
    private static Class _resin_compat_class_0;

    public void setClassLoader(JavaClassLoader loader) {
        this._loader = loader;
    }

    public void setJavaClass(JavaClass javaClass) {
        this._class = javaClass;
    }

    public JavaClass parse(InputStream is) throws IOException {
        this._is = is;
        if (this._loader == null) {
            this._loader = new JavaClassLoader();
        }
        if (this._class == null) {
            this._class = new JavaClass(this._loader);
        }
        this._cp = this._class.getConstantPool();
        this.parseClass();
        return this._class;
    }

    public ConstantPool getConstantPool() {
        return this._cp;
    }

    public String getUTF8(int index) {
        return this.getConstantPool().getUtf8AsString(index);
    }

    private void parseClass() throws IOException {
        int magic = this.readInt();
        if (magic != -889275714) {
            throw this.error(L.l("bad magic number in class file"));
        }
        int minor = this.readShort();
        int major = this.readShort();
        this._class.setMajor(major);
        this._class.setMinor(minor);
        this.parseConstantPool();
        int accessFlags = this.readShort();
        this._class.setAccessFlags(accessFlags);
        int thisClassIndex = this.readShort();
        this._class.setThisClass(this._cp.getClass(thisClassIndex).getName());
        int superClassIndex = this.readShort();
        if (superClassIndex > 0) {
            this._class.setSuperClass(this._cp.getClass(superClassIndex).getName());
        }
        int interfaceCount = this.readShort();
        for (int i = 0; i < interfaceCount; ++i) {
            int classIndex = this.readShort();
            this._class.addInterface(this._cp.getClass(classIndex).getName());
        }
        int fieldCount = this.readShort();
        for (int i = 0; i < fieldCount; ++i) {
            this.parseField();
        }
        int methodCount = this.readShort();
        for (int i = 0; i < methodCount; ++i) {
            this.parseMethod();
        }
        int attrCount = this.readShort();
        for (int i = 0; i < attrCount; ++i) {
            Attribute attr = this.parseAttribute();
            this._class.addAttribute(attr);
        }
    }

    public void parseConstantPool() throws IOException {
        int count = this.readShort();
        for (int i = 1; i < count; ++i) {
            ConstantPoolEntry entry = this.parseConstantPoolEntry(i);
            this._cp.addConstant(entry);
            if (!(entry instanceof DoubleConstant) && !(entry instanceof LongConstant)) continue;
            ++i;
            this._cp.addConstant(null);
        }
    }

    private ConstantPoolEntry parseConstantPoolEntry(int index) throws IOException {
        int tag = this.read();
        switch (tag) {
            case 7: {
                return this.parseClassConstant(index);
            }
            case 9: {
                return this.parseFieldRefConstant(index);
            }
            case 10: {
                return this.parseMethodRefConstant(index);
            }
            case 11: {
                return this.parseInterfaceMethodRefConstant(index);
            }
            case 8: {
                return this.parseStringConstant(index);
            }
            case 3: {
                return this.parseIntegerConstant(index);
            }
            case 4: {
                return this.parseFloatConstant(index);
            }
            case 5: {
                return this.parseLongConstant(index);
            }
            case 6: {
                return this.parseDoubleConstant(index);
            }
            case 12: {
                return this.parseNameAndTypeConstant(index);
            }
            case 1: {
                return this.parseUtf8Constant(index);
            }
        }
        throw this.error(L.l("'{0}' is an unknown constant pool type.", tag));
    }

    private ClassConstant parseClassConstant(int index) throws IOException {
        int nameIndex = this.readShort();
        return new ClassConstant(this._class.getConstantPool(), index, nameIndex);
    }

    private FieldRefConstant parseFieldRefConstant(int index) throws IOException {
        int classIndex = this.readShort();
        int nameAndTypeIndex = this.readShort();
        return new FieldRefConstant(this._class.getConstantPool(), index, classIndex, nameAndTypeIndex);
    }

    private MethodRefConstant parseMethodRefConstant(int index) throws IOException {
        int classIndex = this.readShort();
        int nameAndTypeIndex = this.readShort();
        return new MethodRefConstant(this._class.getConstantPool(), index, classIndex, nameAndTypeIndex);
    }

    private InterfaceMethodRefConstant parseInterfaceMethodRefConstant(int index) throws IOException {
        int classIndex = this.readShort();
        int nameAndTypeIndex = this.readShort();
        return new InterfaceMethodRefConstant(this._class.getConstantPool(), index, classIndex, nameAndTypeIndex);
    }

    private StringConstant parseStringConstant(int index) throws IOException {
        int stringIndex = this.readShort();
        return new StringConstant(this._class.getConstantPool(), index, stringIndex);
    }

    private IntegerConstant parseIntegerConstant(int index) throws IOException {
        int value = this.readInt();
        return new IntegerConstant(this._class.getConstantPool(), index, value);
    }

    private FloatConstant parseFloatConstant(int index) throws IOException {
        int bits = this.readInt();
        float value = Float.intBitsToFloat(bits);
        return new FloatConstant(this._class.getConstantPool(), index, value);
    }

    private LongConstant parseLongConstant(int index) throws IOException {
        long value = this.readLong();
        return new LongConstant(this._class.getConstantPool(), index, value);
    }

    private DoubleConstant parseDoubleConstant(int index) throws IOException {
        long bits = this.readLong();
        double value = Double.longBitsToDouble(bits);
        return new DoubleConstant(this._class.getConstantPool(), index, value);
    }

    private NameAndTypeConstant parseNameAndTypeConstant(int index) throws IOException {
        int nameIndex = this.readShort();
        int descriptorIndex = this.readShort();
        return new NameAndTypeConstant(this._class.getConstantPool(), index, nameIndex, descriptorIndex);
    }

    private Utf8Constant parseUtf8Constant(int index) throws IOException {
        int length = this.readShort();
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < length; ++i) {
            int ch2;
            int ch = this.read();
            if (ch < 128) {
                cb.append((char)ch);
                continue;
            }
            if ((ch & 0xE0) == 192) {
                ch2 = this.read();
                ++i;
                cb.append((char)(((ch & 0x1F) << 6) + (ch2 & 0x3F)));
                continue;
            }
            ch2 = this.read();
            int ch3 = this.read();
            i += 2;
            cb.append((char)(((ch & 0xF) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F)));
        }
        return new Utf8Constant(this._class.getConstantPool(), index, cb.close());
    }

    private void parseField() throws IOException {
        int accessFlags = this.readShort();
        int nameIndex = this.readShort();
        int descriptorIndex = this.readShort();
        JavaField field = new JavaField();
        field.setJavaClass(this._class);
        field.setName(this._cp.getUtf8(nameIndex).getValue());
        field.setDescriptor(this._cp.getUtf8(descriptorIndex).getValue());
        field.setAccessFlags(accessFlags);
        int attributesCount = this.readShort();
        for (int i = 0; i < attributesCount; ++i) {
            Attribute attr = this.parseAttribute();
            field.addAttribute(attr);
        }
        this._class.addField(field);
    }

    private void parseMethod() throws IOException {
        int accessFlags = this.readShort();
        int nameIndex = this.readShort();
        int descriptorIndex = this.readShort();
        JavaMethod method = new JavaMethod(this._loader);
        method.setJavaClass(this._class);
        method.setName(this._cp.getUtf8(nameIndex).getValue());
        method.setDescriptor(this._cp.getUtf8(descriptorIndex).getValue());
        method.setAccessFlags(accessFlags);
        int attributesCount = this.readShort();
        for (int i = 0; i < attributesCount; ++i) {
            ExceptionsAttribute exn;
            ArrayList<String> exnNames;
            Attribute attr = this.parseAttribute();
            method.addAttribute(attr);
            if (!(attr instanceof ExceptionsAttribute) || (exnNames = (exn = (ExceptionsAttribute)attr).getExceptionList()).size() <= 0) continue;
            JClass[] exnClasses = new JClass[exnNames.size()];
            for (int j = 0; j < exnNames.size(); ++j) {
                String exnName = exnNames.get(j).replace('/', '.');
                exnClasses[j] = this._loader.forName(exnName);
            }
            method.setExceptionTypes(exnClasses);
        }
        this._class.addMethod(method);
    }

    Attribute parseAttribute() throws IOException {
        int nameIndex = this.readShort();
        String name = this._cp.getUtf8(nameIndex).getValue();
        if (name.equals("Code")) {
            CodeAttribute code = new CodeAttribute(name);
            code.read(this);
            return code;
        }
        if (name.equals("Exceptions")) {
            ExceptionsAttribute code = new ExceptionsAttribute(name);
            code.read(this);
            return code;
        }
        if (name.equals("Signature")) {
            SignatureAttribute code = new SignatureAttribute();
            code.read(this);
            return code;
        }
        OpaqueAttribute attr = new OpaqueAttribute(name);
        int length = this.readInt();
        byte[] bytes = new byte[length];
        this.read(bytes, 0, bytes.length);
        attr.setValue(bytes);
        return attr;
    }

    long readLong() throws IOException {
        return (long)this._is.read() << 56 | (long)this._is.read() << 48 | (long)this._is.read() << 40 | (long)this._is.read() << 32 | (long)this._is.read() << 24 | (long)this._is.read() << 16 | (long)this._is.read() << 8 | (long)this._is.read();
    }

    int readInt() throws IOException {
        return this._is.read() << 24 | this._is.read() << 16 | this._is.read() << 8 | this._is.read();
    }

    int readShort() throws IOException {
        int c1 = this._is.read();
        int c2 = this._is.read();
        return c1 << 8 | c2;
    }

    int read() throws IOException {
        return this._is.read();
    }

    int read(byte[] buffer, int offset, int length) throws IOException {
        int readLength = 0;
        while (length > 0) {
            int sublen = this._is.read(buffer, offset, length);
            if (sublen < 0) {
                return readLength == 0 ? -1 : readLength;
            }
            offset += sublen;
            length -= sublen;
            readLength += sublen;
        }
        return readLength;
    }

    private IOException error(String message) {
        return new IOException(message);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.ByteCode");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

