/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeClassMatcher;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ByteCodeClassScanner {
    private static final Logger log = Log.open(ByteCodeClassScanner._resin_compat_class_0());
    private static final L10N L = new L10N(ByteCodeClassScanner._resin_compat_class_0());
    private final String _className;
    private final byte[] _buffer;
    private final int _length;
    private final ByteCodeClassMatcher _matcher;
    private int[] _cpOffset = new int[256];
    private int _index;
    private CharBuffer _cb = new CharBuffer();
    private static Class _resin_compat_class_0;

    public ByteCodeClassScanner(String className, byte[] buffer, int offset, int length, ByteCodeClassMatcher matcher) {
        this._className = className;
        this._buffer = buffer;
        this._index = offset;
        this._length = length;
        this._matcher = matcher;
    }

    public boolean scan() {
        try {
            int magic = this.readInt();
            if (magic != -889275714) {
                throw this.error(L.l("bad magic number in class file"));
            }
            int minor = this.readShort();
            int major = this.readShort();
            this.parseConstantPool();
            int accessFlags = this.readShort();
            int thisClassIndex = this.readShort();
            String thisName = this.parseClass(thisClassIndex).toString();
            if (this._matcher.isClassMatch(thisName)) {
                return true;
            }
            int superClassIndex = this.readShort();
            int interfaceCount = this.readShort();
            for (int i = 0; i < interfaceCount; ++i) {
                int classIndex = this.readShort();
            }
            int fieldCount = this.readShort();
            for (int i = 0; i < fieldCount; ++i) {
                if (!this.parseField()) continue;
                return true;
            }
            int methodCount = this.readShort();
            for (int i = 0; i < methodCount; ++i) {
                if (!this.parseMethod()) continue;
                return true;
            }
            int attrCount = this.readShort();
            for (int i = 0; i < attrCount; ++i) {
                if (!this.parseAttribute()) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            log.warning(new CharBuffer().append("failed scanning class ").append(this._className).toString());
            log.log(Level.WARNING, e.toString(), e);
            return false;
        }
    }

    public boolean parseConstantPool() {
        int count = this.readShort();
        int i = 1;
        while (i < count) {
            int code = this.read();
            this.parseConstantPoolEntry(code, i);
            if (code == 5 || code == 6) {
                i += 2;
                continue;
            }
            ++i;
        }
        return false;
    }

    private boolean parseConstantPoolEntry(int tag, int i) {
        switch (tag) {
            case 7: {
                if (this._cpOffset.length <= i) {
                    int[] offset = new int[2 * this._cpOffset.length];
                    System.arraycopy(this._cpOffset, 0, offset, 0, this._cpOffset.length);
                    this._cpOffset = offset;
                }
                this._cpOffset[i] = this._index - 1;
                this._index += 2;
                return false;
            }
            case 9: {
                this._index += 4;
                return false;
            }
            case 10: {
                this._index += 4;
                return false;
            }
            case 11: {
                this._index += 4;
                return false;
            }
            case 8: {
                this._index += 2;
                return false;
            }
            case 3: {
                this._index += 4;
                return false;
            }
            case 4: {
                this._index += 4;
                return false;
            }
            case 5: {
                this._index += 8;
                return false;
            }
            case 6: {
                this._index += 8;
                return false;
            }
            case 12: {
                this._index += 4;
                return false;
            }
            case 1: {
                if (this._cpOffset.length <= i) {
                    int[] offset = new int[2 * this._cpOffset.length];
                    System.arraycopy(this._cpOffset, 0, offset, 0, this._cpOffset.length);
                    this._cpOffset = offset;
                }
                this._cpOffset[i] = this._index - 1;
                int length = this.readShort();
                this._index += length;
                return false;
            }
        }
        throw this.error(L.l("'{0}' is an unknown constant pool type.", tag));
    }

    private boolean parseField() {
        int accessFlags = this.readShort();
        int nameIndex = this.readShort();
        int descriptorIndex = this.readShort();
        int attributesCount = this.readShort();
        for (int i = 0; i < attributesCount; ++i) {
            if (!this.parseAttribute()) continue;
            return true;
        }
        return false;
    }

    private boolean parseMethod() {
        int accessFlags = this.readShort();
        int nameIndex = this.readShort();
        int descriptorIndex = this.readShort();
        int attributesCount = this.readShort();
        for (int i = 0; i < attributesCount; ++i) {
            if (!this.parseAttribute()) continue;
            return true;
        }
        return false;
    }

    boolean parseAttribute() {
        int nameIndex = this.readShort();
        int length = this.readInt();
        int start = this._index;
        CharBuffer name = this.parseUTF8(nameIndex, 0);
        if (name != null && name.matches("RuntimeVisibleAnnotations")) {
            int n = this.readShort();
            for (int i = 0; i < n; ++i) {
                int type = this.readShort();
                name = this.parseUTF8(type, 1);
                name.setLength(name.length() - 1);
                if (this._matcher.isMatch(name)) {
                    return true;
                }
                int nPairs = this.readShort();
                for (int j = 0; j < nPairs; ++j) {
                    int valueName = this.readShort();
                    this.parseElementValue();
                }
            }
        }
        this._index = start + length;
        return false;
    }

    private void parseElementValue() {
        int tag = this.read();
        switch (tag) {
            case 115: {
                this._index += 2;
                break;
            }
            case 101: {
                this._index += 4;
                break;
            }
            case 99: {
                this._index += 2;
                break;
            }
            case 64: {
                throw new IllegalStateException();
            }
            case 91: {
                int n = this.readShort();
                for (int i = 0; i < n; ++i) {
                    this.parseElementValue();
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private CharBuffer parseClass(int index) {
        int offset = this._cpOffset[index] + 1;
        return this.parseUTF8((this._buffer[offset] & 0xFF) * 256 + (this._buffer[offset + 1] & 0xFF), 0);
    }

    private CharBuffer parseUTF8(int index, int skip) {
        int offset = this._cpOffset[index] + 1;
        byte[] bBuf = this._buffer;
        int len = ((bBuf[offset] & 0xFF) << 8) + (bBuf[offset + 1] & 0xFF);
        this._cb.ensureCapacity(len);
        int end = (offset += 2) + len;
        char[] cBuf = this._cb.getBuffer();
        int cLen = -skip;
        while (offset < end) {
            int d2;
            int d1 = bBuf[offset] & 0xFF;
            if (d1 < 128) {
                if (d1 == 47) {
                    d1 = 46;
                }
                if (cLen < 0) {
                    ++cLen;
                } else {
                    cBuf[cLen++] = (char)d1;
                }
                ++offset;
                continue;
            }
            if (d1 < 224) {
                d2 = bBuf[offset + 1] & 0x3F;
                if (cLen < 0) {
                    ++cLen;
                } else {
                    cBuf[cLen++] = (char)(((d1 & 0x1F) << 6) + d2);
                }
                offset += 2;
                continue;
            }
            if (d1 < 240) {
                d2 = bBuf[offset + 1] & 0x3F;
                int d3 = bBuf[offset + 1] & 0x3F;
                if (cLen < 0) {
                    ++cLen;
                } else {
                    cBuf[cLen++] = (char)(((d1 & 0xF) << 12) + (d2 << 6) + d3);
                }
                offset += 2;
                continue;
            }
            throw new IllegalStateException();
        }
        this._cb.setLength(cLen);
        return this._cb;
    }

    private long readLong() {
        return (long)this.read() << 56 | (long)this.read() << 48 | (long)this.read() << 40 | (long)this.read() << 32 | (long)this.read() << 24 | (long)this.read() << 16 | (long)this.read() << 8 | (long)this.read();
    }

    private int readInt() {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    private int readShort() {
        int c1 = this.read();
        int c2 = this.read();
        return c1 << 8 | c2;
    }

    private int read() {
        if (this._index < this._length) {
            return this._buffer[this._index++] & 0xFF;
        }
        return -1;
    }

    private IllegalStateException error(String message) {
        return new IllegalStateException(message);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.bytecode.ByteCodeClassScanner");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

