/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.entity.EntityItem;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class Type {
    private static final L10N L = new L10N(Type._resin_compat_class_0());
    private static Class _resin_compat_class_0;

    public abstract String getName();

    public boolean isBoolean() {
        return false;
    }

    public String getJavaTypeName() {
        return this.getName();
    }

    public int getColumnCount() {
        return 1;
    }

    public void init() throws ConfigException {
    }

    public Type getForeignType() {
        return this;
    }

    public String getForeignTypeName() {
        return this.getForeignType().getJavaTypeName();
    }

    public String generateCreateColumnSQL(AmberManager manager, int length, int precision, int scale) {
        if (length == 0) {
            length = 255;
        }
        return manager.getCreateColumnSQL(12, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return this.getForeignType().generateLoad(out, rs, indexVar, index);
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        this.generateSet(out, pstmt, index, null);
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        pstmt.setObject(index, value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return rs.getObject(index);
    }

    public EntityItem findItem(AmberConnectionImpl aConn, ResultSet rs, int index) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Object getObject(AmberConnectionImpl aConn, ResultSet rs, int index) throws SQLException {
        return this.getObject(rs, index);
    }

    public String toObject(String value) {
        return value;
    }

    public String fromObject(String value) {
        return this.generateCastFromObject(value);
    }

    public Object toObject(long value) {
        return new Long(value);
    }

    public String generateCastFromObject(String value) {
        return new CharBuffer().append("((").append(this.getName()).append(") ").append(value).append(")").toString();
    }

    public String generateEquals(String a, String b) {
        return new CharBuffer().append(a).append(".equals(").append(b).append(")").toString();
    }

    public String generateIsNull(String value) {
        return new CharBuffer().append("(").append(value).append(" == ").append(this.generateNull()).append(")").toString();
    }

    public String generateNull() {
        return "null";
    }

    public boolean isAutoIncrement() {
        return false;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.Type");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

