/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.LongType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;

public class PrimitiveLongType
extends PrimitiveType {
    private static final L10N L = new L10N(PrimitiveLongType._resin_compat_class_0());
    private static final PrimitiveLongType LONG_TYPE = new PrimitiveLongType();
    private static Class _resin_compat_class_0;

    private PrimitiveLongType() {
    }

    public static PrimitiveLongType create() {
        return LONG_TYPE;
    }

    public String getName() {
        return "long";
    }

    public Type getForeignType() {
        return LongType.create();
    }

    public String generateCreateColumnSQL(AmberManager manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(-5, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append(rs).append(".getLong(").append(indexVar).append(" + ").append(index).append(")").toString());
        return index + 1;
    }

    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append("com.caucho.amber.type.PrimitiveLongType.toForeignLong(").append(rs).append(".getLong(").append(indexVar).append(" + ").append(index).append("), ").append(rs).append(".wasNull())").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setLong(").append(index).append("++, ").append(value).append(");").toString());
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.BIGINT);").toString());
    }

    public String toObject(String value) {
        return new CharBuffer().append("new Long(").append(value).append(")").toString();
    }

    public String generateCastFromObject(String value) {
        return new CharBuffer().append("((Number) ").append(value).append(").longValue()").toString();
    }

    public static Long toForeignLong(long value, boolean wasNull) {
        if (wasNull || value == 0L) {
            return null;
        }
        return new Long(value);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.PrimitiveLongType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

