/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.IntegerType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PrimitiveIntType
extends PrimitiveType {
    private static final L10N L = new L10N(PrimitiveIntType._resin_compat_class_0());
    private static final PrimitiveIntType INT_TYPE = new PrimitiveIntType();
    private static Class _resin_compat_class_0;

    private PrimitiveIntType() {
    }

    public static PrimitiveIntType create() {
        return INT_TYPE;
    }

    public String getName() {
        return "int";
    }

    public Type getForeignType() {
        return IntegerType.create();
    }

    public String generateCreateColumnSQL(AmberManager manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(4, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append(rs).append(".getInt(").append(indexVar).append(" + ").append(index).append(")").toString());
        return index + 1;
    }

    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append("com.caucho.amber.type.PrimitiveIntType.toForeignInt(").append(rs).append(".getInt(").append(indexVar).append(" + ").append(index).append("), ").append(rs).append(".wasNull())").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setInt(").append(index).append("++, ").append(value).append(");").toString());
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.INTEGER);").toString());
    }

    public String toObject(String value) {
        return new CharBuffer().append("new Integer(").append(value).append(")").toString();
    }

    public String generateCastFromObject(String value) {
        return new CharBuffer().append("((Number) ").append(value).append(").intValue()").toString();
    }

    public static Integer toForeignInt(int value, boolean wasNull) {
        if (wasNull || value == 0) {
            return null;
        }
        return new Integer(value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        int v = rs.getInt(index);
        return rs.wasNull() ? null : new Integer(v);
    }

    public Object toObject(long value) {
        return new Integer((int)value);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.PrimitiveIntType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

