/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.CharacterType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;

public class PrimitiveCharType
extends PrimitiveType {
    private static final L10N L = new L10N(PrimitiveCharType._resin_compat_class_0());
    private static final PrimitiveCharType CHAR_TYPE = new PrimitiveCharType();
    private static Class _resin_compat_class_0;

    private PrimitiveCharType() {
    }

    public static PrimitiveCharType create() {
        return CHAR_TYPE;
    }

    public String getName() {
        return "char";
    }

    public Type getForeignType() {
        return CharacterType.create();
    }

    public String generateCreateColumnSQL(AmberManager manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(1, 0, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append("com.caucho.amber.type.PrimitiveCharType.toChar(").append(rs).append(".getString(").append(indexVar).append(" + ").append(index).append("))").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setString(").append(index).append("++, String.valueOf(").append(value).append("));").toString());
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.CHAR);").toString());
    }

    public String toObject(String value) {
        return new CharBuffer().append("new Character(").append(value).append(")").toString();
    }

    public String generateCastFromObject(String value) {
        return new CharBuffer().append("((Character) ").append(value).append(").charValue()").toString();
    }

    public static char toChar(String value) {
        if (value == null || value.length() == 0) {
            return '\u0000';
        }
        return value.charAt(0);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.PrimitiveCharType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

