/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ObjectType
extends Type {
    private static final L10N L = new L10N(ObjectType._resin_compat_class_0());
    private static final ObjectType OBJECT_TYPE = new ObjectType();
    private static Class _resin_compat_class_0;

    private ObjectType() {
    }

    public static ObjectType create() {
        return OBJECT_TYPE;
    }

    public String getName() {
        return "java.lang.Object";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append(rs).append(".getObject(").append(indexVar).append(" + ").append(index).append(")").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setObject(").append(index).append("++, ").append(value).append(");").toString());
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        pstmt.setObject(index, value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return rs.getObject(index);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.ObjectType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

