/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.idgen.AmberTableGenerator;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.LongType;
import com.caucho.amber.type.StringType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;

public class GeneratorTableType
extends Type {
    private static final L10N L = new L10N(GeneratorTableType._resin_compat_class_0());
    private AmberManager _amberManager;
    private Table _table;
    private String _keyColumn = "GEN_KEY";
    private String _valueColumn = "GEN_VALUE";
    private HashMap<String, AmberTableGenerator> _genMap = new HashMap();
    private static Class _resin_compat_class_0;

    public GeneratorTableType(AmberManager amberManager, String name) {
        this._amberManager = amberManager;
        this._table = amberManager.createTable(name);
    }

    public AmberManager getAmberManager() {
        return this._amberManager;
    }

    public String getName() {
        return "Generator";
    }

    public Table getTable() {
        return this._table;
    }

    public String getKeyColumn() {
        return this._keyColumn;
    }

    public String getValueColumn() {
        return this._valueColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmberTableGenerator createGenerator(String name) {
        HashMap<String, AmberTableGenerator> hashMap = this._genMap;
        synchronized (hashMap) {
            AmberTableGenerator gen = this._genMap.get(name);
            if (gen == null) {
                gen = new AmberTableGenerator(this.getAmberManager(), this, name);
                this._genMap.put(name, gen);
            }
            return gen;
        }
    }

    public void init() throws ConfigException {
        Column keyColumn = this.getTable().createColumn(this._keyColumn, StringType.create());
        keyColumn.setPrimaryKey(true);
        keyColumn.setLength(254);
        Column valueColumn = this.getTable().createColumn(this._valueColumn, LongType.create());
        if (this.getAmberManager().getCreateDatabaseTables()) {
            this.getTable().createDatabaseTable(this.getAmberManager());
        }
        Iterator<AmberTableGenerator> i$ = this._genMap.values().iterator();
        while (i$.hasNext()) {
            AmberTableGenerator gen = i$.next();
            try {
                gen.init(this.getAmberManager());
            }
            catch (SQLException e) {
                throw new ConfigException(e);
            }
        }
    }

    public String toString() {
        return new CharBuffer().append("GeneratorTableType[").append(this.getName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.GeneratorTableType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

