/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FloatType
extends Type {
    private static final L10N L = new L10N(FloatType._resin_compat_class_0());
    private static final FloatType FLOAT_TYPE = new FloatType();
    private static Class _resin_compat_class_0;

    private FloatType() {
    }

    public static FloatType create() {
        return FLOAT_TYPE;
    }

    public String getName() {
        return "java.lang.Float";
    }

    public String generateCreateColumnSQL(AmberManager manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(7, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append("com.caucho.amber.type.FloatType.toFloat(").append(rs).append(".getFloat(").append(indexVar).append(" + ").append(index).append("), ").append(rs).append(".wasNull())").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append("if (").append(value).append(" == null)").toString());
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.REAL);").toString());
        out.println("else");
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setFloat(").append(index).append("++, ").append(value).append(".floatValue());").toString());
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.REAL);").toString());
    }

    public static Float toFloat(float value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Float(value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        float value = rs.getFloat(index);
        return rs.wasNull() ? null : new Float(value);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.FloatType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

